import asyncio
from playwright.async_api import async_playwright
from captcha_solver import CaptchaSolver

async def main():
    async with async_playwright() as p:
        browser = await p.chromium.launch(headless=False)
        page = await browser.new_page()
        await page.goto('https://site.com/cap')

        solver = CaptchaSolver(
            page=page,
            api_key='YOU_KEY',
            debug=True,
            attempts=5,
        )

        await solver.solve_other()

        await browser.close()

asyncio.run(main())