const { sleep, rand, SelectorStep, parseSelector, findElement, waitForElement, screenshotElement, canvasToBase64, humanMove, humanClick, randomMouseWiggle } = require('./helpers');
const { CapGuruClient } = require('./capguru_client');
const { CaptchaSolverBase } = require('./base_solver');
const { RecaptchaSolver } = require('./recaptcha');
const { OtherSolver } = require('./other');
const { HcaptchaSolver } = require('./hcaptcha');
const { GeetestSolver } = require('./geetest');
const { FuncaptchaSolver } = require('./funcaptcha');
const { TiktokSolver } = require('./tiktok');

class CaptchaSolver {
  constructor({ page, apiKey, server = 'https://api.cap.guru', attempts = 5, debug = false, selector = '' }) {
    this._kwargs = { page, apiKey, server, attempts, debug, selector };
    this.page = page;
    this.apiKey = apiKey;
    this.server = server;
    this.attempts = attempts;
    this.debug = debug;
    this.selector = selector;
    this.client = new CapGuruClient(apiKey, server);
  }

  _make(Cls) {
    return new Cls(this._kwargs);
  }

  async solveRecaptcha2() {
    return await this._make(RecaptchaSolver).solve();
  }

  async solveOther(selector = '') {
    return await this._make(OtherSolver).solve(selector);
  }

  async solveHcaptcha(selector = '') {
    return await this._make(HcaptchaSolver).solve(selector);
  }

  async solveGeetest(selector = '') {
    return await this._make(GeetestSolver).solve(selector);
  }

  async solveFuncaptcha(selector = '') {
    return await this._make(FuncaptchaSolver).solve(selector);
  }

  async solveTiktok(selector = '') {
    return await this._make(TiktokSolver).solve(selector);
  }
}

module.exports = {
  CaptchaSolver,
  RecaptchaSolver,
  OtherSolver,
  HcaptchaSolver,
  GeetestSolver,
  FuncaptchaSolver,
  TiktokSolver,
  CapGuruClient,
  CaptchaSolverBase,
  sleep, rand, SelectorStep, parseSelector,
  findElement, waitForElement,
  screenshotElement, canvasToBase64,
  humanMove, humanClick, randomMouseWiggle,
};
