let capUse = false;
let capUseCount = 0;
let onoffk1 = false, onoffk2 = false;
let addLabels = [];
let textChan;

let selButton = "#home_children_button, #wrong_children_button, #wrongTimeout_children_button, button[data-theme*=verifyButton], [class*=game-fail] .button, .error .button";
let selTitle = "#game_children_text h2, .tile-game h2, .match-game h2";
let selImage = "#game_challengeItem_image, .challenge-container button, .key-frame-image";

document.addEventListener('DOMContentLoaded', async function() {

    let timerId = setInterval(async function() {

        let onoffk1 = !await onoff('funcap');
        if (onoffk1) {
            if (onoffk2 == onoffk1) { return false; }
            log("Plugin OFF");
            onoffk2 = onoffk1;
            return false;
        } else {
            if (onoffk2 != onoffk1) { capUse = false; }
            onoffk2 = false;
        }

        let box = if_checkbox_or_box();
        if (!box) { 
            return false; 
        }

        let urlF = window.location.href;
        if (urlF in addLabels && addLabels[urlF]) {} else {
            addLabels[urlF] = true;
            if (typeof woor !== 'undefined') textChan = new woor(1);
        }

        let el = document.querySelector(selButton + "," + selTitle);

        if (el && isVisible(el)) {
            if (!capUse) {
                capUse = true;
                try {
                    log("Starting new task sequence...");
                    let reskk = await eStart();
                    if (!reskk) {
                        capUseCount++;
                    } else {
                        capUseCount = 0;
                    }
                } catch (e) {
                    console.error("Error in execution loop:", e);
                    if (textChan) textChan.changeStat("Error Exec");
                } finally {
                    capUse = false; 
                    log("Task sequence finished. Freed for next task.");
                }
            }
        } 

        if (capUseCount >= 20) {
            log("Too many errors/retries. Cooling down.");
            capUseCount = 0;
        }

    }, 1000);
});


function if_checkbox_or_box() {
    let url = window.location.href;
    if (url.includes("index.html")) { return true; }
    return false;
}


async function detectCaptcha() {
    const detectionRules = [
        ["script[src*=tile-game-ui]", 0],
        [".tile-game", 1],
        [".match-game", 2]
    ];

    for (const [selector, taskType] of detectionRules) {
        if (document.querySelector(selector)) {
            return taskType;
        }
    }
    return undefined;
}


async function eStart(n = 25) { 
    await sendButton(92, 2); 
    
    let ver = await detectCaptcha();
    if (ver == undefined) { 
        if(textChan) textChan.changeStat("Error 2"); 
        return false; 
    }

    if(textChan) textChan.changeStat("Go...");

    if (ver == 3) { 
        if(textChan) textChan.changeStat("Error 3"); 
        return false; 
    }

    let task = await getTaskTest();
    let img = null;

    if (task == undefined || task == '') { 
        if(textChan) textChan.changeStat("Error 4"); 
        return false; 
    }

    log("Task found:", task);

    let img_old = '';
    
    for (let i = 0; i < n; i++) {
        
        if (!await onoff('funcap')) { 
            log("Plugin OFF in cycle"); 
            return false; 
        }

        if (document.querySelector(selButton)) { 
            log("Button reappeared inside loop, clicking...");
            await sendButton(92, 1); 
            await delay(1000);
            img_old = ''; 
        }

        if (ver == 0) {
            img = await getImageSrc();
        } else if (ver == 1 || ver == 2) {
            let imgEl = document.querySelector(".challenge-container button, .key-frame-image");
            if (imgEl) {
                let canVas = await extractImageToCanvas(imgEl);
                if (canVas != null) {
                    img = canToBasa64(canVas);
                }
            }
        }

        if (img_old == img && img != null && img != "") {
             log("Image same as old one. Checking status...");
             await delay(1000);
             let checkBtn = document.querySelector(selButton);
             if(!checkBtn) {
                 if(textChan) textChan.changeStat("Good"); 
                 return true;
             }
        }

        if (img == "" || img == null) {
            log("No image found, checking finish...");
            await delay(1000);
            if (!document.querySelector(selImage)) {
                 return true;
            }
            if(textChan) textChan.changeStat("Error 5"); 
            return false;
        }

        let res = await sendChrome.X('imgs', { 'click': "funcap", "type": task, 'url': img });
        
        if (res && 'received' in res && res['received'] && res['received'] != '' && res['received'] != 'WAIT' && !hasSrt(res['received'], 'ERROR')) {
            let res1 = res['received'];
            let cells;
            
            if (ver == 0) {
                cells = [...document.querySelectorAll("#game_children_challenge a")];
            } else if (ver == 1) {
                cells = [...document.querySelectorAll(".challenge-container button")];
            }

            let num = parseInt(res1) - 1;

            if (ver == 0 || ver == 1) {
                cells.forEach((cell, index) => {
                    if (index == (num)) {
                        cell.click();
                        log("Clicked cell index:", index);
                    }
                });
            } else if (ver == 2) {
                let by = document.querySelector(".right-arrow");
                let btnSubmit = document.querySelector(".button");
                if(by && btnSubmit){
                    for (let i4 = 0; i4 < num; i4++) { 
                        by.click(); 
                        await delay(150); 
                    }
                    btnSubmit.click();
                }
            }
        } else {
            log("API Error or WAIT");
        }

        img_old = img;
        
        await delay(1500);
        
        if (!document.querySelector(selImage) && !document.querySelector(selTitle)) {
             log("Captcha elements gone. Success?");
             return true; 
        }
    }

    await delay(1000);
    if(textChan) textChan.changeStat("Stop...");
    return true;
}

async function getTaskTest() {
    return new Promise(async (resolve) => {
        let numF = 0;
        while (true) {
            numF++;
            if (numF > 20) { resolve(false); break; }
            let taskEl = document.querySelector(selTitle);
            let task = taskEl?.innerText?.replace(/\s+/g, ' ')?.trim();
            if (task) { resolve(task); break; }
            await delay(200);
        }
    });
}


async function getImageSrc() {
    function getB64(el2) { return el2.src.replace(/data:image\/[a-z]+;base64,/g, ""); }

    return new Promise(async (resolve) => {
        let numF = 0;
        while (true) {
            numF++;
            if (numF > 20) { break; }
            let el = document.querySelector(selImage);
            if (el != null) {
                if ("src" in el && (el.src != null || el.src != "")) {
                    resolve(getB64(el));
                    break;
                }
            }
            await delay(500);
        }
        resolve(false);
    });
}

async function sendButton(n = 394, maxTry = 5) {
    return new Promise(async (resolve) => {
        let numF = 0;
        if(!document.querySelector(selButton)) {
             resolve(true);
             return; 
        }

        while (true) {
            numF++;
            if (numF > maxTry) { break; }
            
            let buttonClickEl = document.querySelector(selButton);
            if (buttonClickEl && isVisible(buttonClickEl)) {
                try {
                    buttonClickEl.click();
                    log('Clicked button', n);
                    await delay(1000); 
                    if(!document.querySelector(selButton)) {
                        resolve(true);
                        break;
                    }
                } catch(err){ log("Click err", err); }
            } else {
                resolve(true);
                break;
            }
            await delay(1000);
        }
        resolve(false);
    });
}


async function extractImageToCanvas(element) {
    let backgroundImage = getComputedStyle(element).backgroundImage;

    if (!backgroundImage || backgroundImage === "none") {
        if ("src" in element && element.src) {
            backgroundImage = `url("{element.src}")`;
        } else {
            return;
        }
    }

    if ("computedStyleMap" in element && !/url\(["']https?:\/\//.test(backgroundImage)) {
        try {
            let styleMapImage = element.computedStyleMap().get("background-image");
            if (styleMapImage instanceof CSSImageValue) {
                let canvas = await convertToCanvas(styleMapImage, element);
                if (canvas) return canvas;
            }
        } catch (e) {}
    }

    let imageUrlMatch = /"(.+)"/.exec(backgroundImage);
    if (!imageUrlMatch) return;
    let imageUrl = imageUrlMatch[1];

    let anchor = document.createElement("a");
    anchor.href = imageUrl;

    if (new URL(anchor.href).origin === document.location.origin) {
        let img = new Image();
        img.crossOrigin = "anonymous";
        img.src = imageUrl;
        let canvas = await convertToCanvas(img);
        if (canvas) return canvas;
    }

    let apiResponse = await sendMessageToExtension("fetch::asData", [imageUrl, {}]);
    if(apiResponse && apiResponse.data) {
        let externalImage = new Image();
        externalImage.crossOrigin = "anonymous";
        externalImage.src = apiResponse.data;
        let canvas = await convertToCanvas(externalImage);
        if (canvas) return canvas;
    }
}


async function convertToCanvas(image, element = null, timeout = 5000) {
    if (!element && !image.complete && !(await waitForImageLoad(image, timeout))) {
        return;
    }

    let width = image.naturalWidth || element?.clientWidth;
    let height = image.naturalHeight || element?.clientHeight;
    
    if(!width || !height) return;

    let canvas = createCanvas(width, height);
    let context = canvas.getContext("2d");
    context.drawImage(image, 0, 0);

    if (isCanvasEmpty(canvas)) {
        return;
    }
    return canvas;
}


function createCanvas(width, height) {
    let canvas = document.createElement("canvas");
    canvas.width = width;
    canvas.height = height;
    return canvas;
}

function isCanvasEmpty(canvas) {
    try {
        let data = canvas.getContext("2d").getImageData(0, 0, 1, 1).data;
        if(data[3] === 0) return false;
    } catch {
        return true;
    }
    return false;
}

function waitForImageLoad(image, timeout) {
    return new Promise((resolve) => {
        let timer = setTimeout(() => {
            resolve(false);
        }, timeout);

        image.addEventListener("load", () => {
            clearTimeout(timer);
            resolve(true);
        });
        image.addEventListener("error", () => {
             clearTimeout(timer);
             resolve(false);
        });
    });
}

function canToBasa64(e) {
    return e.toDataURL("image/jpeg").replace(/data:image\/[a-z]+;base64,/g, "")
}

if (typeof delay === 'undefined') {
    function delay(ms) {
        return new Promise(resolve => setTimeout(resolve, ms));
    }
}

if (typeof isVisible === 'undefined') {
    function isVisible(e) {
        return !!(e.offsetWidth || e.offsetHeight || e.getClientRects().length);
    }
}

if (typeof log === 'undefined') {
    function log(...args) {
        console.log('[FunCaptcha Script]', ...args);
    }
}

if (typeof hasSrt === 'undefined') {
    function hasSrt(str, sub) {
        return str && str.indexOf(sub) > -1;
    }
}
