


let capUse = false;
let capUseCount = 0;
let onoffk2 = false;
let isSolved = false;
let lastTaskHash = null;
let lastCheckboxClick = 0;

const $ = (sel, root = document) => root.querySelector(sel);
const $$ = (sel, root = document) => Array.from(root.querySelectorAll(sel));

function isCheckboxFrame() {
  
  return !!(
    $('#checkbox') ||
    $('.checkbox') ||
    $('div[role="checkbox"]') ||
    $('[data-testid="checkbox"]')
  );
}

function isChallengeFrame() {
  
  if (isCheckboxFrame()) return false;
  return !!(
    $('h2.prompt-text') ||
    $('.prompt-text') ||
    $('[data-testid="prompt-text"]') ||
    $('.task-grid') ||
    $('.task-image') ||
    $('[data-testid="task-image"]') ||
    $('[data-testid="challenge-container"]')
  );
}

function isCheckboxSolved() {
  const cb = $('#checkbox');
  if (cb) {
    const aria = cb.getAttribute('aria-checked');
    if (aria === 'true') return true;
  }
  
  const check = $('.checkmark, .check, .icon-check, [data-testid="checkbox-success"]');
  return !!(check && isVisible(check));
}

function isChallengeSolved() {
  
  const success = $('.verification-success, .prompt-success, .challenge-success, [data-testid="challenge-success"]');
  if (success && isVisible(success)) return true;

  const tiles = $$('.task-image, .task-grid .task-image, [data-testid="task-image"]');
  const prompt = getPromptText();
  
  if (tiles.length === 0 && (!prompt || prompt.length < 3)) return true;

  return false;
}

function getPromptText() {
  const el =
    $('h2.prompt-text') ||
    $('.prompt-text') ||
    $('[data-testid="prompt-text"]') ||
    $('.challenge-header .prompt') ||
    $('.prompt') ||
    $('.task-text') ||
    $('[data-testid="challenge-prompt"]');

  if (!el) return '';
  const t = (el.innerText || el.textContent || '').trim();
  return t.replace(/\s+/g, ' ');
}

function getTileElements() {
  
  let tiles = $$('.task-image');
  if (tiles.length === 0) tiles = $$('.task-grid .task-image');
  if (tiles.length === 0) tiles = $$('[data-testid="task-image"]');
  if (tiles.length === 0) tiles = $$('div[role="button"] img').map(img => img.closest('div[role="button"]')).filter(Boolean);
  return tiles;
}

function getTileImages(tiles) {
  
  return tiles.map(t => t.querySelector('img')).filter(Boolean);
}

async function getB64Smart(url) {
  
  try {
    const b1 = await getBase64FromImageUrl(url);
    if (b1 && typeof b1 === 'string' && b1.length > 50) return b1;
  } catch (e) {}

  try {
    const b2 = await getBase64FromImageUrlYa(url);
    if (b2 && typeof b2 === 'string' && b2.length > 50) return b2;
  } catch (e) {}

  return false;
}

async function waitForChallengeReady(timeoutMs = 20000) {
  const start = Date.now();
  while (Date.now() - start < timeoutMs) {
    const prompt = getPromptText();
    const tiles = getTileElements();
    const imgs = getTileImages(tiles);
    const hasImgs = imgs.length > 0 && imgs.every(i => i.complete && i.naturalWidth > 0 && i.naturalHeight > 0 && i.src);
    if (prompt && prompt.length > 3 && hasImgs) return true;
    await delay(250);
  }
  return false;
}

function clickTile(tile) {
  
  try {
    if (typeof simulate === 'function') {
      simulate(tile, 'click');
      return;
    }
  } catch (e) {}
  try {
    tile.click();
  } catch (e) {}
}

function clickSubmit() {
  const btn =
    $('button[type="submit"]') ||
    $('.button-submit') ||
    $('[data-testid="button-submit"]') ||
    $('[data-testid="challenge-submit"]') ||
    $('button[aria-label*="Verify"]') ||
    $('button[aria-label*="Подтверд"]');

  if (btn && !btn.disabled && isVisible(btn)) {
    try {
      if (typeof simulate === 'function') simulate(btn, 'click');
      else btn.click();
      return true;
    } catch (e) {}
  }
  return false;
}

async function solveChallenge() {
  if (capUse) return false;
  capUse = true;

  try {
    
    const ready = await waitForChallengeReady(25000);
    if (!ready) return false;

    if (isChallengeSolved()) return true;

    const prompt = getPromptText();
    const tiles = getTileElements();
    const imgs = getTileImages(tiles);

    if (!prompt || prompt.length < 3 || imgs.length === 0) return false;

    
    const srcs = imgs.map(i => i.currentSrc || i.src || '').filter(Boolean);
    const hash = JSON.stringify({ prompt, srcs });
    if (lastTaskHash && lastTaskHash === hash) {
      
      await delay(800);
    } else {
      lastTaskHash = hash;
    }

    
    const b64List = [];
    for (const src of srcs) {
      const b64 = await getB64Smart(src);
      if (!b64) {
        log('hCaptcha: failed to fetch image', src);
        return false;
      }
      b64List.push(b64);
    }

    const payload = (b64List.length === 1) ? b64List[0] : b64List;

    const res = await sendChrome.X('imgs', {
      click: 'hcap',
      type: prompt,
      url: payload
    });

    log('hCaptcha API response', res);

    if (!res || !('received' in res) || !res.received || res.received === 'WAIT' || hasSrt(res.received, 'ERROR')) {
      return false;
    }

    if (String(res.received).trim() === 'notpic') {
      
      clickSubmit();
      await delay(1200);
      return isChallengeSolved();
    }

    const idxRaw = String(res.received).replace(/[^0-9,]/g, '');
    const idx = idxRaw.split(',').map(x => parseInt(x, 10)).filter(n => Number.isFinite(n) && n > 0);

    for (const n of idx) {
      const i = n - 1;
      const tile = tiles[i];
      if (tile && isVisible(tile)) {
        await delay(250);
        clickTile(tile);
      }
    }

    await delay(500);
    clickSubmit();
    await delay(2500);

    
    return isChallengeSolved();
  } finally {
    capUse = false;
  }
}

async function tick() {
  if (isSolved) return;

  
  const enabled = await onoff('hcap');
  if (!enabled) {
    if (onoffk2 !== enabled) {
      log('hCaptcha: disabled');
      onoffk2 = enabled;
    }
    return;
  }
  onoffk2 = enabled;

  if (!is_iframe()) return;

  
  if (isCheckboxFrame()) {
    if (isCheckboxSolved()) {
      isSolved = true;
      return;
    }
    const cb = $('#checkbox') || $('.checkbox') || $('div[role="checkbox"]');
    if (cb && isVisible(cb)) {
      
      const now = Date.now();
      if (now - lastCheckboxClick > 2000) {
        lastCheckboxClick = now;
        try {
          if (typeof simulate === 'function') simulate(cb, 'click');
          else cb.click();
        } catch (e) {}
      }
    }
    return;
  }

  
  if (isChallengeFrame()) {
    if (isChallengeSolved()) {
      isSolved = true;
      return;
    }

    if (capUseCount >= 0 && capUseCount < 6) {
      const ok = await solveChallenge();
      if (ok) {
        isSolved = true;
        capUseCount = 0;
        return;
      } else {
        capUseCount++;
      }
    } else {
      capUseCount = -1;
      setTimeout(() => {
        if (!isSolved) {
          capUseCount = 0;
          capUse = false;
        }
      }, 20000);
    }
  }
}

(function init() {
  try {
    const timerId = setInterval(async () => {
      try {
        await tick();
        if (isSolved) clearInterval(timerId);
      } catch (e) {
        
      }
    }, 3000);
  } catch (e) {}
})();
