
class sendChrome {
    static async X(...args) {
        return new Promise(resolve => {
            try {
                if (!chrome.runtime || !chrome.runtime.sendMessage) {
                    console.error('chrome.runtime.sendMessage is not available. Are you in a Chrome extension context?');
                    resolve(null);
                    return;
                }

                
                if (!Array.isArray(args)) {
                    console.error('Arguments should be an array.');
                    resolve(null);
                    return;
                }

                
                chrome.runtime.sendMessage(args, (response) => {
                    if (chrome.runtime.lastError) {
                        console.error('Error in sendMessage:', chrome.runtime.lastError.message);
                        resolve(null);
                    } else {
                        resolve(response);
                    }
                });
            } catch (e) {
                console.error('Failed to execute sendMessage:', e);
                resolve(null);
            }
        });
    }
}


async function getBase64FromImageUrlYa(url, more=1) {
		return new Promise(async (resolve) => {
			
			let op = {};
				let res = await sendChrome.X('fetch', {"url": url, "op": op} );
				
				if (res && 'received' in res && res['received'] && res['received']!='' && res['received']!='WAIT'&& !hasSrt(res['received'],'ERROR')){	
					if(more==2){
						resolve([res['received'], res['url']]);
					}else{
						resolve(res['received']);
					}
					
				}
			
		})
}
async function getBase64FromImageUrl(url) {

	return new Promise(async (resolve) => {
			var img = new Image();

			img.setAttribute('crossOrigin', 'anonymous');

			img.onload = function () {
				var canvas = document.createElement("canvas");
				canvas.width =this.width;
				canvas.height =this.height;

				var ctx = canvas.getContext("2d");
				ctx.drawImage(this, 0, 0);

				var dataURL = canvas.toDataURL("image/png");
				
				resolve(dataURL.replace(/^data:image\/(png|jpg);base64,/, ""));
			};


			img.onerror = async function (error) {
				log ("Failed to load image: " + url);
				resolve(false);
			};

			img.src = url;
	})
}




function isTainted(ctx) {
    try {
        var pixel = ctx.getImageData(0, 0, 1, 1);
        return false;
    } catch(err) {
        return (err.code === 18);
    }
}


function isVisible(elem) {
    if (!(elem instanceof Element)){ log('DomUtil: elem is not an element.'); return false; }
    const style = getComputedStyle(elem);
    if (style.display === 'none') return false;
    if (style.visibility !== 'visible') return false;
    if (style.opacity < 0.1) return false;
    if (elem.offsetWidth + elem.offsetHeight + elem.getBoundingClientRect().height +
        elem.getBoundingClientRect().width === 0) {
        return false;
    }
    const elemCenter   = {
        x: elem.getBoundingClientRect().left + elem.offsetWidth / 2,
        y: elem.getBoundingClientRect().top + elem.offsetHeight / 2
    };
    if (elemCenter.x < 0) return false;
    if (elemCenter.x > (document.documentElement.clientWidth || window.innerWidth)) return false;
    if (elemCenter.y < 0) return false;
    if (elemCenter.y > (document.documentElement.clientHeight || window.innerHeight)) return false;
    let pointContainer = document.elementFromPoint(elemCenter.x, elemCenter.y);
    do {
        if (pointContainer === elem) return true;
    } while (pointContainer = pointContainer.parentNode);
    return false;
}



function simulate(element, eventName)
	{
		
		if(!element){ console.log('Cant found element', 'simulate');  return false; }
		
		var options = extend(defaultOptions, arguments[2] || {});
		var oEvent, eventType = null;

		for (var name in eventMatchers)
		{
			if (eventMatchers[name].test(eventName)) { eventType = name; break; }
		}

		if (!eventType)
			throw new SyntaxError('Only HTMLEvents and MouseEvents interfaces are supported');

		if (document.createEvent)
		{
			oEvent = document.createEvent(eventType);
			if (eventType == 'HTMLEvents')
			{
				oEvent.initEvent(eventName, options.bubbles, options.cancelable);
			}
			else
			{
				oEvent.initMouseEvent(eventName, options.bubbles, options.cancelable, document.defaultView,
				options.button, options.pointerX, options.pointerY, options.pointerX, options.pointerY,
				options.ctrlKey, options.altKey, options.shiftKey, options.metaKey, options.button, element);
			}
			element.dispatchEvent(oEvent);
		}
		else
		{
			options.clientX = options.pointerX;
			options.clientY = options.pointerY;
			var evt = document.createEventObject();
			oEvent = extend(evt, options);
			element.fireEvent('on' + eventName, oEvent);
		}
		return element;
	}

	function extend(destination, source) {
		for (var property in source)
		  destination[property] = source[property];
		return destination;
	}

	var eventMatchers = {
		'HTMLEvents': /^(?:load|unload|abort|error|select|change|submit|reset|focus|blur|resize|scroll)$/,
		'MouseEvents': /^(?:click|dblclick|mouse(?:down|up|over|move|out))$/
	}
	var defaultOptions = {
		pointerX: 0,
		pointerY: 0,
		button: 0,
		ctrlKey: false,
		altKey: false,
		shiftKey: false,
		metaKey: false,
		bubbles: true,
		cancelable: true
	}

var simulateMouseEvent = async function(element, eventName, coordX, coordY) {
  element.dispatchEvent(new MouseEvent(eventName, {
    view: window,
    bubbles: true,
    cancelable: true,
    clientX: coordX,
    clientY: coordY,
    button: 0
  }));
};


delay = ms => new Promise(res => setTimeout(res, ms));

async function elMove(elName, xPlus, yPlus=0){

	let theButton = document.querySelector(elName);

	if(theButton){
		let box = theButton.getBoundingClientRect(),
			coordX = box.left + (box.right - box.left) / 2,
			coordY = box.top + (box.bottom - box.top) / 2;

		await simulateMouseEvent (theButton, "mousedown", coordX, coordY);
		
		for (let i = 0; i < xPlus; i+=5) {
			await delay(50);
			await simulateMouseEvent (theButton, "mousemove", coordX+i, coordY);
		}
		await simulateMouseEvent (theButton, "mouseup", coordX+xPlus, coordY);
	}else{
		console.log("Bad move");
	}


}

async function elClick(elName, xPlus=0, yPlus=0){
	
	
	let theButton ;
	if (typeof elName === 'string' || elName instanceof String){
		theButton = document.querySelector(elName);
	}else{
		theButton = elName;
	}
	
	if(theButton){
	
		let box = theButton.getBoundingClientRect();
		if(xPlus == 0){ xPlus =  (box.right - box.left) / 2; }
		if(yPlus == 0){ xPlus =  (box.bottom - box.top) / 2; }
		let	coordX = box.left + xPlus;
		let coordY = box.top + yPlus;
		simulateMouseEvent (theButton, "click", coordX, coordY);
		
	}else{
		console.log("Can't found where click", elName);
	}
}



function get_image_url(linkp) {
	
	
	
    let matches = linkp?.style['background']?.trim()?.match(/(?!^)".*?"/g);
    if (!matches || matches.length === 0) {
	  matches = linkp?.src
	  if(matches) {  return matches; }
	  return null;
    }
    return matches[0].replaceAll('"', '');
  }



function log(...args) {
	let logs = true;
        if (logs) {
            console.log(...args);
        }
    }
	

		async function area2(namep, data=[]) {
            function clickOnCanvas(canvas, x, y) {
                const rect = canvas.getBoundingClientRect();
                const events = ["mouseover", "mousedown", "mouseup", "click"];
                const options = {
                    
                    clientX: x + rect.left,
                    
                    clientY: y + rect.top,
                    bubbles: true,
                };

                for (let i = 0; i < events.length; i++) {
                    const event = new MouseEvent(events[i], options);
                    canvas.dispatchEvent(event);
                }
            }
            const canvas = document.querySelector(namep);
			if(canvas){
				canvas.addEventListener("mousedown", function (e) {
					const rect = canvas.getBoundingClientRect();
					const x = event.clientX - rect.left;
					const y = event.clientY - rect.top;
					
				});
				const [x, y] = data.length?data:[0,0];
				clickOnCanvas(canvas, x, y);
			}else{
				log("Не смогли нажать на кнопку", namep)
			}
        }



  function is_iframe() {
        try {
            return window.self !== window.top;
        } catch (e) {
            return true;
        }
    }
	
var currentMousePosition = { x: 0, y: 0 };

document.addEventListener('mousemove', function(event) {
    currentMousePosition.x = event.clientX;
    currentMousePosition.y = event.clientY;
});

function simulateHumanLikeMouseMove(selector, endX, endY, duration = 1000) {
    var element = document.querySelector(selector);
    if (!element) {
        throw new Error('Element not found');
    }

    
    var rect = element.getBoundingClientRect();

	startX = currentMousePosition.x;
	startY = currentMousePosition.y


    
    var startClientX = rect.left + startX;
    var startClientY = rect.top + startY;
    var endClientX = rect.left + endX;
    var endClientY = rect.top + endY;

    
    function createEvent(type, clientX, clientY) {
        var event;
        if (window.PointerEvent) {
            event = new PointerEvent(type, {
                bubbles: true,
                cancelable: true,
                view: window,
                clientX: clientX,
                clientY: clientY,
                pointerType: 'mouse'
            });
        } else if (window.MouseEvent) {
            event = new MouseEvent(type, {
                bubbles: true,
                cancelable: true,
                view: window,
                clientX: clientX,
                clientY: clientY
            });
        } else {
            throw new Error('Neither PointerEvent nor MouseEvent is supported');
        }
        element.dispatchEvent(event);
    }

    
    function randomVariation() {
        return Math.random() * 4 - 2; 
    }

    
    function calculateBezierPoints(start, end) {
        var cp1 = { x: start.x + (end.x - start.x) / 3 + randomVariation(), y: start.y + randomVariation() };
        var cp2 = { x: start.x + 2 * (end.x - start.x) / 3 + randomVariation(), y: end.y + randomVariation() };
        return [start, cp1, cp2, end];
    }

    
    function getBezierPoint(points, t) {
        var x = (1 - t) ** 3 * points[0].x + 3 * (1 - t) ** 2 * t * points[1].x + 3 * (1 - t) * t ** 2 * points[2].x + t ** 3 * points[3].x;
        var y = (1 - t) ** 3 * points[0].y + 3 * (1 - t) ** 2 * t * points[1].y + 3 * (1 - t) * t ** 2 * points[2].y + t ** 3 * points[3].y;
        return { x: x, y: y };
    }

    
    function easeInOutQuad(t) {
        return t < 0.5 ? 2 * t * t : -1 + (4 - 2 * t) * t;
    }

    
    var bezierPoints = calculateBezierPoints({ x: startClientX, y: startClientY }, { x: endClientX, y: endClientY });

    
    var steps = duration / 10; 
    for (let i = 0; i <= steps; i++) {
        setTimeout(() => {
            var t = easeInOutQuad(i / steps);
            var point = getBezierPoint(bezierPoints, t);
            createEvent('mousemove', point.x, point.y);
        }, i * 10); 
    }
}


function simulateMouseAndPointerEvents(selector, button = 0, x=null, y=null) {
    var element = document.querySelector(selector);
    if (!element) {
        throw new Error('Element not found');
    }

    
    var rect = element.getBoundingClientRect();
    var centerX =  rect.left +  (x !== null ? x : (rect.width / 2));
    var centerY =  rect.top + (y !== null ? y : (rect.height / 2));

    
    function createEvent(type, button, clientX, clientY) {
        var event;
        if (window.PointerEvent) {
            event = new PointerEvent(type, {
                bubbles: true,
                cancelable: true,
                view: window,
                clientX: clientX,
                clientY: clientY,
                button: button,
                pointerType: 'mouse'
            });
        } else if (window.MouseEvent) {
            event = new MouseEvent(type, {
                bubbles: true,
                cancelable: true,
                view: window,
                clientX: clientX,
                clientY: clientY,
                button: button
            });
        } else {
            throw new Error('Neither PointerEvent nor MouseEvent is supported');
        }
        element.dispatchEvent(event);
    }

    
    createEvent('pointerenter', button, centerX, centerY);
    createEvent('mouseenter', button, centerX, centerY);

    
    createEvent('pointerover', button, centerX, centerY);
    createEvent('mouseover', button, centerX, centerY);

    
    var steps = 20;
    var startX = window.innerWidth / 2;
    var startY = window.innerHeight / 2;
    var deltaX = (centerX - startX) / steps;
    var deltaY = (centerY - startY) / steps;

    for (let i = 0; i <= steps; i++) {
        setTimeout(() => {
            var randomX = Math.random() * 5 - 2.5; 
            var randomY = Math.random() * 5 - 2.5; 
            var currentX = startX + deltaX * i + randomX;
            var currentY = startY + deltaY * i + randomY;
            createEvent('pointermove', button, currentX, currentY);
            createEvent('mousemove', button, currentX, currentY);
        }, i * 50); 
    }

    
    setTimeout(() => {
        createEvent('pointerdown', button, centerX, centerY);
        createEvent('mousedown', button, centerX, centerY);

        setTimeout(() => {
            createEvent('pointerup', button, centerX, centerY);
            createEvent('mouseup', button, centerX, centerY);

            setTimeout(() => {
                createEvent('click', button, centerX, centerY);

                setTimeout(() => {
                    createEvent('pointerout', button, centerX, centerY);
                    createEvent('mouseout', button, centerX, centerY);
                    createEvent('pointerleave', button, centerX, centerY);
                    createEvent('mouseleave', button, centerX, centerY);
                }, 50); 
            }, 100); 
        }, 100); 
    }, steps * 50 + 50); 
}




class Time {
    static time() {
        if (!Date.now) {
            Date.now = () => new Date().getTime();
        }
        return Date.now();
    }

    static date() {
        return new Date();
    }

    static sleep(i=1000) {
        return new Promise(resolve => setTimeout(resolve, i));
    }

    static async random_sleep(min, max) {
        const duration = Math.floor(Math.random() * (max - min) + min);
        return await Time.sleep(duration);
    }
}


async function onoff(asl){
	res = await sendChrome.X('get', {});
	let mainOff = false;
	if (res && 'received' in res && res['received'] && res['received'] != ''){
		let set = res['received'];
		mainOff = 'onoff' in set && set['onoff'] == '1'; 
		
		if(set && asl in set && (set[asl] == '0' || set[asl] == '')){ return false; } 
		
		if('onoff2' in set && mainOff){ 
			if(set['onoff2'] == '0'){
				
				console.log('Пустой баланс');  mainOff = false;
			}
		}
		if(!mainOff){ return false; }
		if(set && asl in set ){	return set[asl] == '1'; }		
	}
	return false;
}


function hasSrt(str, word) {
    return (str).indexOf(word) > -1;
}


async function sliceOG(elName) {
    const originalCanvas = document.querySelector(elName);
    if (!originalCanvas) return null;

    const originalCtx = originalCanvas.getContext("2d", { willReadFrequently: true });
    const [originalWidth, originalHeight] = [originalCanvas.width, originalCanvas.height];

    
    const originalImageData = originalCtx.getImageData(0, 0, originalWidth, originalHeight);
    const { data } = originalImageData;
    let hasValidContent = false;

    
    for (let i = 0; i < data.length; i += 4) {
        if (data[i + 3] !== 0 && (data[i] !== 0 || data[i + 1] !== 0 || data[i + 2] !== 0)) {
            hasValidContent = true;
            break;
        }
    }

    if (!hasValidContent) {
        console.error("The original canvas has no valid content");
        return null;
    }

    const desiredWidth = parseInt(originalCanvas.style.width, 10);
    const desiredHeight = parseInt(originalCanvas.style.height, 10);

    if (isNaN(desiredWidth) || isNaN(desiredHeight) || desiredWidth <= 0 || desiredHeight <= 0) {
        console.error("Desired width and height should be positive numbers");
        return null;
    }

    const scaleFactor = Math.min(desiredWidth / originalWidth, desiredHeight / originalHeight);
    const [outputWidth, outputHeight] = [originalWidth * scaleFactor, originalHeight * scaleFactor];

    const outputCanvas = document.createElement("canvas");
    Object.assign(outputCanvas, { width: outputWidth, height: outputHeight });

    const ctx = outputCanvas.getContext("2d", { willReadFrequently: true });
    ctx.drawImage(originalCanvas, 0, 0, originalWidth, originalHeight, 0, 0, outputWidth, outputHeight);

    return outputCanvas.toDataURL("image/jpeg", 0.4).replace(/^data:image\/(png|jpeg);base64,/, "");
}


var MD5 = function(d){var r = M(V(Y(X(d),8*d.length)));return r.toLowerCase()};function M(d){for(var _,m="0123456789ABCDEF",f="",r=0;r<d.length;r++)_=d.charCodeAt(r),f+=m.charAt(_>>>4&15)+m.charAt(15&_);return f}function X(d){for(var _=Array(d.length>>2),m=0;m<_.length;m++)_[m]=0;for(m=0;m<8*d.length;m+=8)_[m>>5]|=(255&d.charCodeAt(m/8))<<m%32;return _}function V(d){for(var _="",m=0;m<32*d.length;m+=8)_+=String.fromCharCode(d[m>>5]>>>m%32&255);return _}function Y(d,_){d[_>>5]|=128<<_%32,d[14+(_+64>>>9<<4)]=_;for(var m=1732584193,f=-271733879,r=-1732584194,i=271733878,n=0;n<d.length;n+=16){var h=m,t=f,g=r,e=i;f=md5_ii(f=md5_ii(f=md5_ii(f=md5_ii(f=md5_hh(f=md5_hh(f=md5_hh(f=md5_hh(f=md5_gg(f=md5_gg(f=md5_gg(f=md5_gg(f=md5_ff(f=md5_ff(f=md5_ff(f=md5_ff(f,r=md5_ff(r,i=md5_ff(i,m=md5_ff(m,f,r,i,d[n+0],7,-680876936),f,r,d[n+1],12,-389564586),m,f,d[n+2],17,606105819),i,m,d[n+3],22,-1044525330),r=md5_ff(r,i=md5_ff(i,m=md5_ff(m,f,r,i,d[n+4],7,-176418897),f,r,d[n+5],12,1200080426),m,f,d[n+6],17,-1473231341),i,m,d[n+7],22,-45705983),r=md5_ff(r,i=md5_ff(i,m=md5_ff(m,f,r,i,d[n+8],7,1770035416),f,r,d[n+9],12,-1958414417),m,f,d[n+10],17,-42063),i,m,d[n+11],22,-1990404162),r=md5_ff(r,i=md5_ff(i,m=md5_ff(m,f,r,i,d[n+12],7,1804603682),f,r,d[n+13],12,-40341101),m,f,d[n+14],17,-1502002290),i,m,d[n+15],22,1236535329),r=md5_gg(r,i=md5_gg(i,m=md5_gg(m,f,r,i,d[n+1],5,-165796510),f,r,d[n+6],9,-1069501632),m,f,d[n+11],14,643717713),i,m,d[n+0],20,-373897302),r=md5_gg(r,i=md5_gg(i,m=md5_gg(m,f,r,i,d[n+5],5,-701558691),f,r,d[n+10],9,38016083),m,f,d[n+15],14,-660478335),i,m,d[n+4],20,-405537848),r=md5_gg(r,i=md5_gg(i,m=md5_gg(m,f,r,i,d[n+9],5,568446438),f,r,d[n+14],9,-1019803690),m,f,d[n+3],14,-187363961),i,m,d[n+8],20,1163531501),r=md5_gg(r,i=md5_gg(i,m=md5_gg(m,f,r,i,d[n+13],5,-1444681467),f,r,d[n+2],9,-51403784),m,f,d[n+7],14,1735328473),i,m,d[n+12],20,-1926607734),r=md5_hh(r,i=md5_hh(i,m=md5_hh(m,f,r,i,d[n+5],4,-378558),f,r,d[n+8],11,-2022574463),m,f,d[n+11],16,1839030562),i,m,d[n+14],23,-35309556),r=md5_hh(r,i=md5_hh(i,m=md5_hh(m,f,r,i,d[n+1],4,-1530992060),f,r,d[n+4],11,1272893353),m,f,d[n+7],16,-155497632),i,m,d[n+10],23,-1094730640),r=md5_hh(r,i=md5_hh(i,m=md5_hh(m,f,r,i,d[n+13],4,681279174),f,r,d[n+0],11,-358537222),m,f,d[n+3],16,-722521979),i,m,d[n+6],23,76029189),r=md5_hh(r,i=md5_hh(i,m=md5_hh(m,f,r,i,d[n+9],4,-640364487),f,r,d[n+12],11,-421815835),m,f,d[n+15],16,530742520),i,m,d[n+2],23,-995338651),r=md5_ii(r,i=md5_ii(i,m=md5_ii(m,f,r,i,d[n+0],6,-198630844),f,r,d[n+7],10,1126891415),m,f,d[n+14],15,-1416354905),i,m,d[n+5],21,-57434055),r=md5_ii(r,i=md5_ii(i,m=md5_ii(m,f,r,i,d[n+12],6,1700485571),f,r,d[n+3],10,-1894986606),m,f,d[n+10],15,-1051523),i,m,d[n+1],21,-2054922799),r=md5_ii(r,i=md5_ii(i,m=md5_ii(m,f,r,i,d[n+8],6,1873313359),f,r,d[n+15],10,-30611744),m,f,d[n+6],15,-1560198380),i,m,d[n+13],21,1309151649),r=md5_ii(r,i=md5_ii(i,m=md5_ii(m,f,r,i,d[n+4],6,-145523070),f,r,d[n+11],10,-1120210379),m,f,d[n+2],15,718787259),i,m,d[n+9],21,-343485551),m=safe_add(m,h),f=safe_add(f,t),r=safe_add(r,g),i=safe_add(i,e)}return Array(m,f,r,i)}function md5_cmn(d,_,m,f,r,i){return safe_add(bit_rol(safe_add(safe_add(_,d),safe_add(f,i)),r),m)}function md5_ff(d,_,m,f,r,i,n){return md5_cmn(_&m|~_&f,d,_,r,i,n)}function md5_gg(d,_,m,f,r,i,n){return md5_cmn(_&f|m&~f,d,_,r,i,n)}function md5_hh(d,_,m,f,r,i,n){return md5_cmn(_^m^f,d,_,r,i,n)}function md5_ii(d,_,m,f,r,i,n){return md5_cmn(m^(_|~f),d,_,r,i,n)}function safe_add(d,_){var m=(65535&d)+(65535&_);return(d>>16)+(_>>16)+(m>>16)<<16|65535&m}function bit_rol(d,_){return d<<_|d>>>32-_}


class woor{
	
  constructor(n) {
    
	console.log("Add complete ", window.location.href);
	let theButton = document.querySelector("body");

	if(!theButton){ console.log('Cant found element', 'add_button_to_start');  return false; }

	let dm = document.createElement("div");
	dm.style.cssText = "position: relative; top: 2px; left: 2px; z-index:9;";

	
	let dm2 = document.createElement("div");
	dm2.style.cssText = "border:1px solid #fff;position: absolute; background: #3598dc; color: #fff; font-size: 13px; width: 80px; text-indent: 4px;";
	dm.appendChild(dm2);

	
	this.dm3 = document.createElement("div");
	this.dm3.style.cssText = "width: 100%; display: block;";
	this.dm3.className = "capguru_box_render_go";
	this.dm3.innerText = "Start";
	dm2.appendChild(this.dm3);


	this.dm3.addEventListener("click", async function() {
		console.log("capguru_box_render_go clicked!");
		
		
		await eStart(n);
	});

	
	

	
	theButton.insertBefore(dm, theButton.firstChild);
	
  }
  
	changeStat(t){
		
		if (this.dm3) { this.dm3.innerText = t; } else { log("dm3 не найден!"); }
		
		
		log("t", t);
	}
  
  
  
  
}