let capUse = false;
let onoffk1 = false, onoffk2 = false;
let capUseCount = 0;

document.addEventListener('DOMContentLoaded', async function() {
    let maxuse = 3;

    let timerId = setInterval(async () => {
        let onoffk1 = !await onoff('tiktok');
        if(onoffk1) { 
            if(onoffk2 == onoffk1) { return false; } 
            log("Plugin OFF");
            onoffk2 = onoffk1;
            return false;
        } else { 
            if(onoffk2 != onoffk1) { capUse = false; }
            onoffk2 = false; 
        }

        if(!capUse) {
            let el; 
            
            // Проверяем старый селектор
            el = document.querySelector(".captcha_verify_container");
            if(el && isVisible(el)) {
                console.log("OLD CAPTCHA SHOW");
                capUse = true;
                if(maxuse < 0) { console.log("Sorry, we can't solved"); clearInterval(timerId); }
                maxuse--;
                await eStart();
            }
            
            // Проверяем новый селектор для обновленного дизайна
            el = document.querySelector(".TUXModal.captcha-verify-container");
            if(el && isVisible(el) && capUseCount >= 0 && capUseCount < 5) {
                if(!capUse) {
                    capUse = true;
                    console.log("NEW CAPTCHA SHOW");
                    let reskk = await eStartNew();
                    if(!reskk) { 
                        capUseCount++; 
                    } else { 
                        capUseCount = 0; 
                    }
                    capUse = false;
                }
            } else if(capUseCount >= 5) {
                capUseCount = -1;
                setTimeout(() => { capUseCount = 0; capUse = false; }, 20000);
            }
        }
    }, 2 * 1000);
});

// Улучшенная функция для получения base64 из blob URL
async function getBlobAsBase64(blobUrl) {
    try {
        const response = await fetch(blobUrl);
        if (!response.ok) {
            throw new Error(`Failed to fetch blob: ${response.status}`);
        }
        const blob = await response.blob();
        return new Promise((resolve, reject) => {
            const reader = new FileReader();
            reader.onloadend = () => {
                const base64 = reader.result.replace(/^data:image\/(png|jpeg|jpg|webp);base64,/, "");
                resolve(base64);
            };
            reader.onerror = () => reject(new Error("Failed to read blob"));
            reader.readAsDataURL(blob);
        });
    } catch (error) {
        console.error("Error converting blob to base64:", error);
        return null;
    }
}

// Улучшенная функция для получения base64 из любого URL
async function getImageAsBase64(url) {
    if (!url) return null;
    
    try {
        if (url.startsWith("blob:")) {
            return await getBlobAsBase64(url);
        } else if (url.startsWith("data:")) {
            return url.replace(/^data:image\/(png|jpeg|jpg|webp);base64,/, "");
        } else {
            return await getBase64FromImageUrl(url);
        }
    } catch (error) {
        console.error("Error getting image as base64:", error);
        return null;
    }
}

// Исправленная функция определения типа капчи
async function detectCaptchaType(container) {
    if (!container) return "unknown";
    
    const images = container.querySelectorAll("img");
    const imageCount = images.length;
    
	if(imageCount == 1){ return "abc"; }
	if(imageCount == 3){ return "slider"; }
	if(imageCount == 2){ return "koleso"; }
	
	/*
	
	

    // Проверяем наличие слайдера
    const hasSlider = container.querySelector("div.cap-flex.cap-absolute") !== null ||
                     container.querySelector("#captcha_slide_button") !== null ||
                     container.querySelector(".secsdk-captcha-drag-icon") !== null ||
                     container.querySelector(".captcha_verify_img_slide") !== null;
    
    // Проверяем наличие кнопки клика
    const hasClickButton = container.querySelector(".TUXButton-label") !== null ||
                          container.querySelector(".verify-captcha-submit-button") !== null;
    
    // Проверяем специфические элементы для вращения (whirl) - старая структура
    const hasWhirlOuter = container.querySelector("[data-testid=\"whirl-outer-img\"]") !== null;
    const hasWhirlInner = container.querySelector("[data-testid=\"whirl-inner-img\"]") !== null;
    const hasRotateElements = hasWhirlOuter && hasWhirlInner;
    
    // Получаем текст инструкции для дополнительной проверки
    const instructionText = container.querySelector("span.cap-flex.cap-items-center")?.textContent?.trim().toLowerCase() || "";
    
    // Проверяем структуру для новой капчи с вращением
    const hasCircleClipPath = Array.from(images).some(img => 
        img.style.clipPath && img.style.clipPath.includes("circle")
    );
    
    // Проверяем наличие transform rotate в стилях
    const hasRotateTransform = Array.from(images).some(img => 
        img.style.transform && img.style.transform.includes("rotate")
    );
    
    // Проверяем позиционирование изображений (абсолютное для внутреннего круга)
    const hasAbsolutePositioning = Array.from(images).some(img => 
        img.classList.contains("cap-absolute")
    );
    
    // Проверяем текст инструкции на наличие ключевых слов
    const isDragPuzzle = instructionText.includes("drag") && instructionText.includes("puzzle");
    const isSlideInstruction = instructionText.includes("slide");
    
    console.log("Captcha detection:", {
        imageCount,
        hasSlider,
        hasClickButton,
        hasRotateElements,
        hasWhirlOuter,
        hasWhirlInner,
        instructionText,
        hasCircleClipPath,
        hasRotateTransform,
        hasAbsolutePositioning,
        isDragPuzzle,
        isSlideInstruction
    });
    
    // ИСПРАВЛЕННАЯ логика определения типа
    if (imageCount === 2 && hasCircleClipPath && hasAbsolutePositioning && isDragPuzzle) {
        console.log("Detected: koleso (rotation captcha with circle clips and absolute positioning)");
        return "koleso"; // Новая капча с вращением - круглые изображения с абсолютным позиционированием
    } else if (imageCount === 2 && hasRotateElements) {
        console.log("Detected: koleso (rotation captcha with whirl elements)");
        return "koleso"; // Старая капча с вращением - два изображения с whirl элементами
    } else if (hasSlider && (imageCount === 1 || imageCount === 2)) {
        // ДЛЯ СЛАЙДЕРА: всегда возвращаем "slider", независимо от количества изображений
        console.log("Detected: slider (slider captcha)");
        return "slider"; // Слайдер (может иметь 1 или 2 изображения, но отправляем только основное)
    } else if (imageCount === 1 && hasClickButton) {
        console.log("Detected: abc (click captcha)");
        return "abc"; // Капча с кликами
    } else if (imageCount === 1) {
        console.log("Detected: abc (default single image)");
        return "abc"; // По умолчанию капча с выбором/кликами
    }
    */
    console.log("Detected: unknown");
    return "unknown";
}

// Функция обновления капчи (перемещена выше для доступности)
let lastRefreshTime = 0;
const REFRESH_COOLDOWN = 3000; // 3 секунды между обновлениями

async function refreshCaptcha(container) {
    const now = Date.now();
    
    // Проверяем cooldown
    if (now - lastRefreshTime < REFRESH_COOLDOWN) {
        console.log("Refresh on cooldown, skipping...");
        return false;
    }
    
    lastRefreshTime = now;
    console.log("Refreshing captcha...");
    
    // Пытаемся найти кнопку обновления в новом дизайне
    const refreshButtons = [
        container.querySelector("#captcha_refresh_button"),
        container.querySelector(".captcha-refresh-button"),
        container.querySelector("[data-testid='refresh-button']"),
        ...Array.from(container.querySelectorAll("button")).filter(btn => 
            btn.innerHTML.includes("refresh") ||
            btn.innerHTML.includes("M56.62 21a25.5 25.5") ||
            btn.title?.toLowerCase().includes("refresh")
        )
    ].filter(btn => btn);
    
    if (refreshButtons.length > 0) {
        console.log("Found refresh button, clicking...");
        refreshButtons[0].click();
        await delay(2000);
        return true;
    }
    
    // Если не нашли, пытаемся старые методы
    console.log("No refresh button found, trying old methods...");
    await refresh();
    return false;
}

// Исправленная функция получения изображений
async function getImagesAsBase64Array(container, captchaType) {
    if (!container) return [];
    
    let images = [];
    
    if (captchaType === "koleso") {
        // Для koleso всегда нужны 2 изображения
        const outerImg = container.querySelector("[data-testid=\"whirl-outer-img\"]");
        const innerImg = container.querySelector("[data-testid=\"whirl-inner-img\"]");
        
        if (outerImg && innerImg) {
            console.log("Found whirl elements (old structure)");
            images = [outerImg, innerImg];
        } else {
            // Новая структура - ищем изображения с круглыми clip-path
            const allImages = Array.from(container.querySelectorAll("img"));
            
            // Сортируем изображения: сначала не абсолютные (внешний круг), потом абсолютные (внутренний круг)
            const regularImages = allImages.filter(img => !img.classList.contains("cap-absolute"));
            const absoluteImages = allImages.filter(img => img.classList.contains("cap-absolute"));
            
            // Внешний круг (больший) - первое обычное изображение
            if (regularImages.length > 0) {
                images.push(regularImages[0]);
                console.log("Found outer circle image (regular positioning)");
            }
            
            // Внутренний круг (меньший) - первое абсолютное изображение
            if (absoluteImages.length > 0) {
                images.push(absoluteImages[0]);
                console.log("Found inner circle image (absolute positioning)");
            }
            
            // Fallback: если структура не совпадает, берем первые два
            if (images.length === 0 && allImages.length >= 2) {
                images = [allImages[0], allImages[1]];
                console.log("Fallback to first 2 images for koleso");
            }
        }
        
        console.log("Koleso images found:", { 
            count: images.length,
            sources: images.map(img => ({
                src: img.src?.substring(0, 50) + "...",
                hasClipPath: !!img.style.clipPath,
                isAbsolute: img.classList.contains("cap-absolute"),
                transform: img.style.transform
            }))
        });
    } else if (captchaType === "slider") {
        // ДЛЯ СЛАЙДЕРА: отправляем только ОДНО изображение (основное)
        const allImages = Array.from(container.querySelectorAll("img"));
        
        // Ищем основное изображение слайдера (обычно первое или самое большое)
        if (allImages.length > 0) {
            // Приоритет: изображение с ID captcha-verify-image или первое изображение
            const mainImage = container.querySelector("#captcha-verify-image") || 
                             container.querySelector(".captcha_verify_img_slide") ||
                             allImages[0];
            
            if (mainImage) {
                images = [mainImage];
                console.log("Found main slider image:", {
                    src: mainImage.src?.substring(0, 50) + "...",
                    id: mainImage.id,
                    className: mainImage.className
                });
            }
        }
    } else {
        // Для остальных типов ищем все изображения
        images = Array.from(container.querySelectorAll("img"));
    }
    
    const imageData = [];
    
    for (let i = 0; i < images.length; i++) {
        const img = images[i];
        console.log(`Processing image ${i + 1}/${images.length}:`, {
            src: img.src?.substring(0, 100) + "...",
            type: img.src?.startsWith('blob:') ? 'blob' : img.src?.startsWith('data:') ? 'data' : 'url',
            clipPath: img.style.clipPath,
            transform: img.style.transform,
            classes: img.className
        });
        
        const base64Data = await getImageAsBase64(img.src);
        if (base64Data) {
            imageData.push(base64Data);
            console.log(`Image ${i + 1} converted to base64, length:`, base64Data.length);
        } else {
            console.error(`Failed to convert image ${i + 1} to base64`);
        }
    }
    
    console.log(`Retrieved ${imageData.length} images for type ${captchaType}`);
    return imageData;
}

// Универсальная функция для выполнения перетаскивания (перемещена в начало)
async function performDragAction(element, distance) {
    console.log("Starting drag action with distance:", distance);
    
    const rect = element.getBoundingClientRect();
    const startX = rect.left + rect.width / 2;
    const startY = rect.top + rect.height / 2;
    
    // Создаем события перетаскивания
    const mouseDownEvent = new MouseEvent("mousedown", {
        clientX: startX,
        clientY: startY,
        bubbles: true,
        cancelable: true,
        buttons: 1
    });
    
    element.dispatchEvent(mouseDownEvent);
    await delay(100);
    
    // Плавное перемещение
    const steps = 20;
    const stepDistance = distance / steps;
    
    for (let i = 1; i <= steps; i++) {
        const currentX = startX + (stepDistance * i);
        
        const mouseMoveEvent = new MouseEvent("mousemove", {
            clientX: currentX,
            clientY: startY,
            bubbles: true,
            cancelable: true,
            buttons: 1
        });
        
        element.dispatchEvent(mouseMoveEvent);
        
        // Также отправляем drag событие для новых элементов
        const dragEvent = new DragEvent("drag", {
            clientX: currentX,
            clientY: startY,
            bubbles: true,
            cancelable: true
        });
        
        element.dispatchEvent(dragEvent);
        
        await delay(50);
    }
    
    const finalX = startX + distance;
    
    const mouseUpEvent = new MouseEvent("mouseup", {
        clientX: finalX,
        clientY: startY,
        bubbles: true,
        cancelable: true,
        buttons: 0
    });
    
    element.dispatchEvent(mouseUpEvent);
    
    // Также отправляем dragend событие
    const dragEndEvent = new DragEvent("dragend", {
        clientX: finalX,
        clientY: startY,
        bubbles: true,
        cancelable: true
    });
    
    element.dispatchEvent(dragEndEvent);
    
    console.log("Drag action completed");
    await delay(300);
}

// Улучшенная функция извлечения координат из ответа
function extractCoordinatesFromResponse(result) {
    console.log("Extracting coordinates from:", result);
    
    let x = 0, y = 0, w = 0;
    
    // Формат: coordinates:x=263,y=114,w=97
    if (result.includes("coordinates:")) {
        const xMatch = result.match(/x=(\d+)/);
        const yMatch = result.match(/y=(\d+)/);
        const wMatch = result.match(/w=(\d+)/);
        
        if (xMatch) x = parseInt(xMatch[1]);
        if (yMatch) y = parseInt(yMatch[1]);
        if (wMatch) w = parseInt(wMatch[1]);
        
        console.log("Extracted from coordinates format:", { x, y, w });
        return { x, y, w };
    }
    
    // Формат: x=263;y=114
    if (result.includes("x=") && result.includes("y=")) {
        const xMatch = result.match(/x=(\d+)/);
        const yMatch = result.match(/y=(\d+)/);
        
        if (xMatch) x = parseInt(xMatch[1]);
        if (yMatch) y = parseInt(yMatch[1]);
        
        console.log("Extracted from x=;y= format:", { x, y, w: 0 });
        return { x, y, w: 0 };
    }
    
    // Формат: простые координаты через запятую
    const cleanResult = result.replace(/[^0-9,]/g, "");
    const coords = cleanResult.split(",");
    
    if (coords.length >= 2) {
        x = parseInt(coords[0]) || 0;
        y = parseInt(coords[1]) || 0;
        if (coords.length >= 3) {
            w = parseInt(coords[2]) || 0;
        }
        
        console.log("Extracted from comma format:", { x, y, w });
        return { x, y, w };
    }
    
    console.log("Could not extract coordinates, using defaults");
    return { x: 0, y: 0, w: 0 };
}

// Исправленная обработка ответа для слайдера (точно как в старом коде)
async function handleSlideResponse(result, container, captchaType) {
    console.log("Handling slide response:", result);
    
    // ТОЧНО КАК В СТАРОМ КОДЕ: извлекаем только цифры и берем первый параметр [0]
    let res1 = result.replace(/[^0-9,]/g, "");
    res1 = res1.split(",")[0]; // Для slider всегда берем первый параметр (индекс 0)
    res1 = parseInt(res1);
    
    console.log("Extracted coordinates from response:", {
        originalResult: result,
        cleanedNumbers: result.replace(/[^0-9,]/g, ""),
        splitArray: result.replace(/[^0-9,]/g, "").split(","),
        selectedValue: res1,
        selectedIndex: 0
    });
    
    // Получаем изображение для масштабирования (точно как в старом коде)
    const el2 = container.querySelector("#captcha-verify-image") || 
               container.querySelector("img");
    
    if (el2 && el2.naturalHeight > 0) {
        // ТОЧНАЯ ФОРМУЛА ИЗ СТАРОГО КОДА
        res1 = Math.round(res1 / el2.naturalHeight * el2.offsetHeight);
        console.log("Scaling calculation (OLD CODE FORMULA):", {
            originalValue: parseInt(result.replace(/[^0-9,]/g, "").split(",")[0]),
            naturalHeight: el2.naturalHeight,
            offsetHeight: el2.offsetHeight,
            scaleFactor: el2.offsetHeight / el2.naturalHeight,
            result: res1
        });
    }
    
    // Вычитаем 5 как в старом коде
    const finalDistance = res1 - 5;
    
    console.log("Final distance for slider:", finalDistance);
    
    // Ищем элемент для перетаскивания точно как в старом коде
    const dragElement = container.querySelector('.cap-rounded-full > div');
    
    if (dragElement) {
        console.log("Starting dragAndDrop2 with distance:", finalDistance);
        await dragAndDrop2Exact(dragElement, finalDistance);
        
        // Даем время на обработку
        await delay(1000);
        
        // Нажимаем кнопку подтверждения
        const confirmButton = container.querySelector('.TUXButton-label') ||
                            container.querySelector('.verify-captcha-submit-button') ||
                            container.querySelector('button[type="submit"]');
        
        if (confirmButton) {
            console.log("Clicking confirm button...");
            confirmButton.click();
        }
        
    } else {
        console.error("Drag element (.cap-rounded-full > div) not found");
    }
}

// Исправленная обработка ответа для вращения (возвращаем первоначальный вариант)
async function handleRotateResponse(result, container) {
    console.log("Handling rotate response:", result);
    
    // Извлекаем координаты из ответа
    const coords = extractCoordinatesFromResponse(result);
    let angle = coords.y; // Для koleso обычно используем Y как угол
    
    if (isNaN(angle) || angle < 0) {
        console.error("Invalid angle value:", angle, "from result:", result);
        return;
    }
    
    console.log("Extracted angle for rotation:", angle);
    
    // Ищем элемент для вращения
    const rotateElement = container.querySelector('.cap-rounded-full > div') ||
                         container.querySelector('.secsdk-captcha-drag-icon') ||
                         container.querySelector('#captcha_slide_button') ||
                         container.querySelector('[draggable="true"]');
    
    if (rotateElement) {
        console.log("Found rotate element, applying rotation...");
        await performTikTokSliderCorrect(rotateElement, angle);
    } else {
        console.error("Rotate element not found");
        // Выводим все возможные элементы для отладки
        const allDraggable = container.querySelectorAll('[draggable], .cap-rounded-full, .secsdk-captcha-drag-icon, button');
        console.log("Available draggable elements:", allDraggable);
    }
}

// Исправленная обработка ответа для кликов
async function handleClickResponse(result, container) {
    console.log("Handling click response:", result);
    
    const cleanResult = result.replace(/[^0-9,\;]/g, "");
    const coordinates = cleanResult.split(";");
    
    const imageElement = container.querySelector("img");
    if (!imageElement) {
        console.error("Image element not found for clicks");
        return;
    }
    
    for (let coordStr of coordinates) {
        const [xStr, yStr] = coordStr.split(",");
        let x = parseInt(xStr);
        let y = parseInt(yStr);
        
        if (isNaN(x) || isNaN(y)) {
            console.warn("Invalid coordinates:", coordStr);
            continue;
        }
        
        // Масштабируем координаты под размер элемента
        if (imageElement.naturalHeight > 0 && imageElement.naturalWidth > 0) {
            y = Math.round(y / imageElement.naturalHeight * imageElement.offsetHeight);
            x = Math.round(x / imageElement.naturalWidth * imageElement.offsetWidth);
        }
        
        console.log("Clicking at:", x, y);
        
        await delay(500);
        await elClick(imageElement, x, y);
        await delay(1200);
    }
    
    await delay(2000);
    
    // Отправляем ответ
    const submitButton = container.querySelector(".TUXButton-label") ||
                        container.querySelector(".verify-captcha-submit-button");
    
    if (submitButton) {
        console.log("Clicking submit button...");
        submitButton.click();
    }
}

// Функция для обработки ответа от сервера (обновленная)
async function handleCaptchaResponse(response, captchaType, container) {
    try {
        const result = response['received'];
        console.log("Handling captcha response:", { type: captchaType, result });
        
        if (captchaType === "slider") {
            await handleSlideResponse(result, container, captchaType);
        } else if (captchaType === "koleso") {
            await handleRotateResponse(result, container);
        } else if (captchaType === "abc") {
            await handleClickResponse(result, container);
        } else {
            console.warn("Unknown captcha type for response handling:", captchaType);
        }
        
        await delay(2000);
    } catch (error) {
        console.error("Error handling captcha response:", error);
    }
}

// Исправленная основная функция для обработки новых капч
async function eStartNew() {
    if (!await onoff('tiktok')) { 
        log("Plugin OFF in cycle");  
        return false; 
    }
    
    const container = document.querySelector(".TUXModal.captcha-verify-container");
    if (!container || !isVisible(container)) {
        return false;
    }
    
    try {
        // Определяем тип капчи
        const captchaType = await detectCaptchaType(container);
        console.log("Detected captcha type:", captchaType);
        
        if (captchaType === "unknown") {
            console.warn("Unknown captcha type, refreshing...");
            await refreshCaptcha(container);
            capUse = false;
            return false;
        }
        
        // Получаем изображения в base64
        const imageData = await getImagesAsBase64Array(container, captchaType);
        
        if (imageData.length === 0) {
            console.warn("No images found, refreshing...");
            await refreshCaptcha(container);
            capUse = false;
            return false;
        }
        
        console.log("Sending captcha data:", { type: captchaType, images: imageData.length });
        
        // ИСПРАВЛЕННАЯ подготовка данных для отправки
        let requestData;
        
        if (captchaType === "koleso" && imageData.length === 2) {
            // Для koleso отправляем массив из двух изображений
            requestData = {
                'click': "tiktok", 
                "type": "koleso", 
                'url': imageData  // Массив [outerImg, innerImg]
            };
            console.log("Sending koleso data with 2 images");
        } else if (captchaType === "slider") {
            // ДЛЯ СЛАЙДЕРА: всегда отправляем ОДНО изображение, даже если их несколько
            requestData = {
                'click': "tiktok", 
                "type": "slider", 
                'url': imageData[0]  // Только первое (основное) изображение
            };
            console.log("Sending slider data with 1 image (main image only)");
        } else if (imageData.length === 1) {
            // Для одиночных изображений (abc)
            requestData = {
                'click': "tiktok", 
                "type": captchaType, 
                'url': imageData[0]  // Одно изображение
            };
            console.log("Sending single image data for type:", captchaType);
        } else {
            console.error("Unexpected image data configuration:", {
                type: captchaType,
                imageCount: imageData.length
            });
            await refreshCaptcha(container);
            capUse = false;
            return false;
        }
        
        // Отправляем данные в background script
        const response = await sendChrome.X('imgs', requestData);
        console.log("Response received:", response);
        
        // Проверяем ответ более строго
        if (!response || !response.received) {
            console.warn("No response received, refreshing...");
            await refreshCaptcha(container);
            capUse = false;
            return false;
        }
        
        const result = response.received;
        
        // Проверяем на ошибки
        if (result === 'WAIT' || result === '' || hasSrt(result, 'ERROR')) {
            console.warn("Invalid response:", result, "refreshing...");
            await refreshCaptcha(container);
            capUse = false;
            return false;
        }
        
        // Дополнительная проверка для koleso - должно содержать координаты
        if (captchaType === "koleso") {
            const cleanResult = result.replace(/[^0-9,]/g, "");
            const coordinates = cleanResult.split(",");
            
            if (coordinates.length < 2) {
                console.warn("Invalid koleso response - insufficient coordinates:", result);
                await refreshCaptcha(container);
                capUse = false;
                return false;
            }
        }
        
        // Если все проверки прошли, обрабатываем ответ
        await handleCaptchaResponse(response, captchaType, container);
        return true;
        
    } catch (error) {
        console.error("Error in eStartNew:", error);
        await refreshCaptcha(container);
        capUse = false;
        return false;
    }
}

// Функции перетаскивания из оригинального tiktok.js
async function triggerDragEvent(element, eventName, options = {}) {
    const rect = element.getBoundingClientRect();
    const { clientX = rect.left, clientY = rect.top } = options;

    // Create a simulated `DragEvent` instead of a regular `Event`
    const dragEvent = new DragEvent(eventName, {
        bubbles: true,
        cancelable: true,
        clientX: clientX,
        clientY: clientY,
        dataTransfer: new DataTransfer() // Use the built-in `DataTransfer` for compatibility
    });

    // Set up `dataTransfer` with necessary methods and properties
    dragEvent.dataTransfer.setDragImage = (img, xOffset, yOffset) => {
        console.log('setDragImage called with:', img, xOffset, yOffset);
    };

    element.dispatchEvent(dragEvent);
}

// Функция для koleso (точная формула из вашего объяснения)
async function dragAndDropKoleso(selector, angle) {
    const element = typeof selector === 'string' ? document.querySelector(selector) : selector;
    if (!element) throw new Error("Элемент не найден");

    const rect = element.getBoundingClientRect();
    const container = element.parentElement.getBoundingClientRect();
    const startX = rect.left + rect.width / 2;
    const startY = rect.top + rect.height / 2;

    // ТОЧНАЯ ФОРМУЛА: angle/271*(containerWidth-elementWidth)
    const CONSTANT = 271;
    const elementWidth = rect.width;
    const containerWidth = container.width;
    const maxMovement = containerWidth - elementWidth;
    const offsetX = Math.round((angle / CONSTANT) * maxMovement);

    console.log("Koleso drag calculation:", {
        angle: angle,
        constant: CONSTANT,
        containerWidth: containerWidth,
        elementWidth: elementWidth,
        maxMovement: maxMovement,
        offsetX: offsetX,
        formula: `${angle}/${CONSTANT}*(${containerWidth}-${elementWidth}) = ${offsetX}`
    });

    // Limit the target coordinates within the container bounds
    const maxX = container.right - rect.width / 2;
    const targetX = Math.min(maxX, startX + offsetX);
    const targetY = startY;

    // Start with `dragstart` event
    await triggerDragEvent(element, 'dragstart', { clientX: startX, clientY: startY });
    
    // Generate `drag` events for each step in the drag path
    for (let i = 0; i <= offsetX; i += 5) {
        const intermediateX = startX + i;
        await triggerDragEvent(element, 'drag', { clientX: intermediateX, clientY: targetY });
        await new Promise(resolve => setTimeout(resolve, 20));
    }
    
    await triggerDragEvent(element, 'drag', { clientX: targetX, clientY: targetY });
    await new Promise(resolve => setTimeout(resolve, 100));

    await triggerDragEvent(element, 'dragend', { clientX: targetX, clientY: targetY });
    
    console.log("Koleso drag completed. Moved to:", targetX);
}

// Функция для slider (из оригинального файла)
async function dragAndDropSlider(selector, offsetX = 100) {
    const element = typeof selector === 'string' ? document.querySelector(selector) : selector;
    if (!element) throw new Error("Элемент не найден");

    const rect = element.getBoundingClientRect();
    const container = element.parentElement.getBoundingClientRect();
    const startX = rect.left + rect.width / 2;
    const startY = rect.top + rect.height / 2;

    // Limit the target coordinates within the container bounds
    const maxX = container.right - rect.width / 2;
    const targetX = Math.min(maxX, startX + offsetX);
    const targetY = startY;

    // Start with `dragstart` event
    await triggerDragEvent(element, 'dragstart', { clientX: startX, clientY: startY });
    
    // Generate `drag` events for each step in the drag path
    for (let i = 0; i <= offsetX; i += 5) {
        const intermediateX = startX + i;
        
        await triggerDragEvent(element, 'drag', { clientX: intermediateX, clientY: targetY });
        await new Promise(resolve => setTimeout(resolve, 20));
        
        // Проверяем позицию элемента для точной остановки
        let ce = document.querySelector(".captcha-verify-container img+div");
        if (ce) {
            let sto = ce.getAttribute('style');
            let find3 = sto.match(/\(([0-9.]+)px\)/);
            
            if (find3 && find3.length > 1) {
                let found4 = parseInt(find3[1]);
                if (found4 > offsetX) { 
                    offsetX = intermediateX; 
                    await triggerDragEvent(element, 'drag', { clientX: intermediateX, clientY: targetY });
                    await new Promise(resolve => setTimeout(resolve, 20));
                    break; 
                }
            }
        }
    }

    await new Promise(resolve => setTimeout(resolve, 100));
    await triggerDragEvent(element, 'dragend', { clientX: targetX, clientY: targetY });
}

// Точная копия dragAndDrop2 из старого рабочего кода
async function dragAndDrop2Exact(element, offsetX = 100) {
    if (!element) throw new Error("Элемент не найден");

    console.log("Starting EXACT dragAndDrop2 from old code with offsetX:", offsetX);

    const rect = element.getBoundingClientRect();
    const container = element.parentElement.getBoundingClientRect();
    const startX = rect.left + rect.width / 2;
    const startY = rect.top + rect.height / 2;

    // Limit the target coordinates within the container bounds
    const maxX = container.right - rect.width / 2;
    const targetX = Math.min(maxX, startX + offsetX);
    const targetY = startY;

    console.log("EXACT dragAndDrop2 coordinates:", {
        startX, startY, offsetX, targetX, maxX,
        elementRect: rect,
        containerRect: container
    });

    // Start with `dragstart` event
    await triggerDragEvent(element, 'dragstart', { clientX: startX, clientY: startY });
    
    // Generate `drag` events for each step in the drag path
    for (let i = 0; i <= offsetX; i += 5) {
        const intermediateX = startX + i;
        
        await triggerDragEvent(element, 'drag', { clientX: intermediateX, clientY: targetY });
        await new Promise(resolve => setTimeout(resolve, 20));
        
        // ТОЧНАЯ КОПИЯ ПРОВЕРКИ ИЗ СТАРОГО КОДА
        let ce = document.querySelector(".captcha-verify-container img+div");
        
        if (ce) {
            let sto = ce.getAttribute('style');
            
            if (sto) {
                let find3 = sto.match(/\(([0-9.]+)px\)/);
                
                if (find3 && find3.length > 1) {
                    let found4 = parseInt(find3[1]);
                    console.log("Position check - found4:", found4, "offsetX:", offsetX, "i:", i);
                    
                    if (found4 > offsetX) { 
                        console.log("EXACT TARGET REACHED! found4 > offsetX:", found4, ">", offsetX);
                        
                        // ТОЧНО КАК В СТАРОМ КОДЕ: переприсваиваем offsetX = intermediateX
                        offsetX = intermediateX; 
                        
                        await triggerDragEvent(element, 'drag', { clientX: intermediateX, clientY: targetY });
                        await new Promise(resolve => setTimeout(resolve, 20));
                        
                        break; 
                    }
                }
            }
        } else {
            console.log("Element .captcha-verify-container img+div not found at step", i);
        }
    }

    await new Promise(resolve => setTimeout(resolve, 100));
    await triggerDragEvent(element, 'dragend', { clientX: targetX, clientY: targetY });
    
    console.log("EXACT dragAndDrop2 completed");
}

// Правильная функция для TikTok слайдера (возвращаем первоначальный вариант)
async function performTikTokSliderCorrect(element, angle) {
    console.log("Performing TikTok slider with EXACT formula and original drag method. Angle:", angle);
    
    // Используем оригинальный метод перетаскивания для koleso
    try {
        await dragAndDropKoleso(element, angle);
        console.log("Koleso drag method completed successfully");
        return true;
    } catch (error) {
        console.error("Koleso drag method failed:", error);
        
        // Fallback: простое перетаскивание
        try {
            const CONSTANT = 271;
            const rect = element.getBoundingClientRect();
            const container = element.parentElement?.getBoundingClientRect() || rect;
            const maxMovement = container.width - rect.width;
            const offsetX = Math.round((angle / CONSTANT) * maxMovement);
            
            await dragAndDropSlider(element, offsetX);
            console.log("Fallback slider drag completed");
            return true;
        } catch (fallbackError) {
            console.error("Fallback drag also failed:", fallbackError);
            return false;
        }
    }
}

// Оригинальная функция eStart для старого дизайна (сохраняем для совместимости)
async function eStart() {
    let el, el2, el3;
    let res;
    
    for (let i = 0; i < 5; i++) { 
        if(!await onoff('tiktok')) { 
            log("Plugin OFF in cycle");  
            return false; 
        }
    
        let typeCap = "";
        let capImg = "";
        res = null;
        
        el = document.querySelector("#captcha-verify-image");
        console.log(el);
        
        if(el && isVisible(el)) {
            typeCap = "abc";
            let url = el.src;
            if (url !== undefined) {
                el2 = el;
                console.log('clientHeight', el2.offsetHeight, el2.clientHeight);
                
                // Обновленная обработка изображений
                capImg = await getImageAsBase64(url);
            } else {
                console.log("cant get url");
            }
            
            el = document.querySelector(".captcha_verify_img_slide");
            if(el && isVisible(el)) {
                typeCap = "slider";
            }
            
            console.log("Send", typeCap);
            res = await sendChrome.X('imgs', {'click': "tiktok", "type": typeCap, 'url': capImg});
            console.log(res);
        }
        
        el = document.querySelector("[data-testid=\"whirl-outer-img\"]");
        
        if(typeCap.length == 0 && el) {
            typeCap = "koleso";
            let url1 = el.src;
            el = document.querySelector("[data-testid=\"whirl-inner-img\"]");
            let url2 = el.src;
            
            // Обновленная обработка для blob URL
            const img1Base64 = await getImageAsBase64(url1);
            const img2Base64 = await getImageAsBase64(url2);
            
            console.log("Send", typeCap, url1, url2);
            res = await sendChrome.X('imgs', {'click': "tiktok", "type": typeCap, 'url': [img1Base64, img2Base64]});
            console.log(res);
        }
        
        if (res && 'received' in res && res['received'] && res['received'] !== '' && 
            res['received'] !== 'WAIT' && !hasSrt(res['received'], 'ERROR')) {
            
            let res1;
            if(typeCap == "koleso" || typeCap == "slider") {
                res1 = res['received'].replace(/[^0-9,]/g, "");
                res1 = res1.split(",")[typeCap == "koleso" ? 1 : 0];
                res1 = parseInt(res1);
                if(typeCap == "slider") {  
                    res1 = Math.round(res1 / el2.naturalHeight * el2.offsetHeight);
                }
                
                await elMove(".secsdk-captcha-drag-icon", parseInt(res1), 0);
                
            } else if(typeCap == "abc") {
                console.log('res', res);
                console.log('res_rec', res['received']);
                res1 = res['received'];
                res1 = res1.replace(/[^0-9,\;]/g, "");
                let res2 = res1.split(";");
                
                for(let k in res2) {
                    let wq = res2[k].split(",");
                    let xp = parseInt(wq[0]), yp = parseInt(wq[1]);
                    
                    yp = Math.round(yp / el2.naturalHeight * el2.offsetHeight);
                    xp = Math.round(xp / el2.naturalWidth * el2.offsetWidth);
                
                    await delay(500);
                    await elClick("#captcha-verify-image", xp, yp);
                    await delay(1200);
                }
                await delay(2000);
                document.querySelector(".verify-captcha-submit-button").click();
            }
        } else {
            await refresh();
            capUse = false;
            return false;
        }
        await delay(3000);
    }
    
    console.log("document Error");
}

async function refresh() {
    await elClick(".secsdk_captcha_refresh");
    return await delay(2000);
}

async function clickButtonRef(send = 0) {
    let items = document.querySelectorAll(".captcha-verify-container button, .TUXModal button");
    if(items.length > 0) {
        for (let i = 0, len = items.length; i < len; i++) {
            let htmlr = items[i].innerHTML;
            if(send == 1) {
                if(!contian(htmlr, "iconContainer")) {
                    await elClick(items[i]);
                    return true;
                }
            } else {
                if(contian(htmlr, "M56.62 21a25.5 25.5") || contian(htmlr, "refresh")) {
                    await elClick(items[i]);
                    return true;
                }
            }
        }
    }
    
    // Дополнительные селекторы для новых кнопок
    let refreshBtn = document.querySelector("#captcha_refresh_button");
    if (refreshBtn && send == 0) {
        await elClick(refreshBtn);
        return true;
    }
    
    let submitBtn = document.querySelector(".TUXButton-label");
    if (submitBtn && send == 1) {
        await elClick(submitBtn);
        return true;
    }
}

function contian(str, word) {
    return str.indexOf(word) !== -1;
}