var ses = {};
let preloadedData = null;
let configData = null;
let isPreloading = false;
let preloadPromise = null;
function getBrowserLanguageInBackground() {
    try {
        const lang = chrome.i18n.getUILanguage() || 'en';
        const langCode = lang.toLowerCase().split('-')[0];
        return langCode === 'ru' ? 'ru' : 'en';
    } catch (error) {
        console.warn('Не удалось определить язык браузера:', error);
        return 'en';
    }
}
function logErrorWithLanguage(error, context = '') {
    const lang = getBrowserLanguageInBackground();
    const prefix = lang === 'ru' ? '❌ Ошибка' : '❌ Error';
    if (context) {
        console.error(`${prefix} (${context}):`, error);
    } else {
        console.error(`${prefix}:`, error);
    }
}
function logSuccessWithLanguage(message, context = '') {
    const lang = getBrowserLanguageInBackground();
    const prefix = lang === 'ru' ? '✅ Успех' : '✅ Success';
    if (context) {
        console.log(`${prefix} (${context}): ${message}`);
    } else {
        console.log(`${prefix}: ${message}`);
    }
}
class ApiManager {
    static #encodedServers = {
        primary: 'aHR0cHM6Ly9hcGkyLmNhcC5ndXJ1Lw==',
        russian: 'aHR0cHM6Ly9hcGkuY2FwLmd1cnUv',
        ipv6: 'aHR0cHM6Ly9pcHY2LmNhcC5ndXJ1Lw=='
    };
    static #getDecodedUrl(key) {
        try {
            const encoded = this.#encodedServers[key];
            if (!encoded) return null;
            const decoded = atob(encoded);
            if (!decoded.includes('cap.guru')) {
                throw new Error('Invalid server configuration');
            }
            return decoded;
        } catch (error) {
            console.error('Server configuration error:', error);
            return null;
        }
    }
    static #getAllServers() {
        const servers = {};
        const keys = Object.keys(this.#encodedServers);
        for (let i = 0; i < keys.length; i++) {
            const key = keys[i];
            const url = this.#getDecodedUrl(key);
            if (url) {
                servers[key] = url;
            }
        }
        return servers;
    }
    static get allServers() {
        return this.#getAllServers();
    }
    static servers = [];
    static currentServerIndex = 0;
    static lastHealthCheck = 0;
    static healthCheckInterval = 3 * 60 * 1000;
    static serverStatus = new Map();
    static maxRetries = 3;
    static retryDelay = 300;
    static browserLanguage = '';
    static isInitialized = false;
    static #verifyServerIntegrity() {
        const servers = this.#getAllServers();
        const serverUrls = Object.values(servers);
        for (let i = 0; i < serverUrls.length; i++) {
            const url = serverUrls[i];
            if (!url || !url.includes('cap.guru') || !url.startsWith('https://'))  {
                throw new Error('Server configuration compromised');
            }
        }
        return true;
    }
    static detectLanguageAndPrioritize() {
        try {
            this.#verifyServerIntegrity();
            this.browserLanguage = chrome.i18n.getUILanguage() || 'en';
        } catch (error) {
            this.browserLanguage = 'en';
        }
        const languageCode = this.browserLanguage.toLowerCase().split('-')[0];
        const allServers = this.allServers;
        if (languageCode === 'ru') {
            this.servers = [
                allServers.russian,
                allServers.primary,
                allServers.ipv6
            ];
            console.log('🇷🇺 Русский язык обнаружен, приоритет российским серверам');
        } else {
            this.servers = [
                allServers.primary,
                allServers.russian,
                allServers.ipv6
            ];
            console.log('🇺🇸 English detected, priority to primary servers');
        }
        return this.servers;
    }
    static init() {
        if (this.isInitialized) return;
        try {
            this.#verifyServerIntegrity();
            this.detectLanguageAndPrioritize();
            const serverList = Object.values(this.allServers);
            for (let i = 0; i < serverList.length; i++) {
                const server = serverList[i];
                this.serverStatus.set(server, {
                    available: true,
                    lastError: null,
                    errorCount: 0,
                    lastChecked: 0,
                    priority: this.servers.indexOf(server) + 1
                });
            }
            this.isInitialized = true;
        } catch (error) {
            console.error('Failed to initialize ApiManager:', error);
            throw error;
        }
    }
    static getCurrentServer() {
        if (!this.isInitialized) {
            throw new Error('ApiManager not initialized');
        }
        return this.servers[this.currentServerIndex];
    }
    static getInUrl() {
        return this.getCurrentServer() + 'in.php';
    }
    static getResUrl() {
        return this.getCurrentServer() + 'res.php';
    }
    static switchToNextServer() {
        const previousIndex = this.currentServerIndex;
        this.currentServerIndex = (this.currentServerIndex + 1) % this.servers.length;
        const status = this.serverStatus.get(this.servers[previousIndex]);
        if (status) {
            status.available = false;
            status.errorCount++;
            status.lastChecked = Date.now();
        }
        return this.getCurrentServer();
    }
    static getOptimalServerForLanguage() {
        const languageCode = this.browserLanguage.toLowerCase().split('-')[0];
        const allServers = this.allServers;
        return languageCode === 'ru' ? allServers.russian : allServers.primary;
    }
    static isPreferredServer(serverUrl) {
        return serverUrl === this.getOptimalServerForLanguage();
    }
    static async checkServerHealth(serverUrl) {
        try {
            if (!serverUrl || !serverUrl.includes('cap.guru')) {
                throw new Error('Invalid server URL');
            }
            const controller = new AbortController();
            const timeoutId = setTimeout(() => controller.abort(), 2000);
            const response = await fetch(serverUrl + 'res.php?action=getbalance&key=test', {
                method: 'GET',
                signal: controller.signal,
                cache: 'no-cache'
            });
            clearTimeout(timeoutId);
            const isHealthy = response.ok || response.status === 200;
            const status = this.serverStatus.get(serverUrl);
            if (status) {
                status.available = isHealthy;
                status.lastChecked = Date.now();
                if (isHealthy) {
                    status.errorCount = 0;
                    status.lastError = null;
                }
            }
            return isHealthy;
        } catch (error) {
            const status = this.serverStatus.get(serverUrl);
            if (status) {
                status.available = false;
                status.lastError = error.message;
                status.errorCount++;
                status.lastChecked = Date.now();
            }
            return false;
        }
    }
    static async findAvailableServer() {
        const currentServer = this.getCurrentServer();
        if (await this.checkServerHealth(currentServer)) {
            return currentServer;
        }
        const optimalServer = this.getOptimalServerForLanguage();
        if (optimalServer !== currentServer && await this.checkServerHealth(optimalServer)) {
            this.currentServerIndex = this.servers.indexOf(optimalServer);
            return optimalServer;
        }
        for (let i = 0; i < this.servers.length; i++) {
            const serverIndex = (this.currentServerIndex + i + 1) % this.servers.length;
            const server = this.servers[serverIndex];
            if (await this.checkServerHealth(server)) {
                this.currentServerIndex = serverIndex;
                return server;
            }
        }
        return null;
    }
    static async makeRequest(url, options) {
        if (!url || !url.includes('cap.guru')) {
            throw new Error('Invalid request URL');
        }
        options = options || {};
        let lastError = null;
        for (let attempt = 0; attempt < this.maxRetries; attempt++) {
            try {
                const controller = new AbortController();
                const timeoutId = setTimeout(() => controller.abort(), 8000);
                const response = await fetch(url, Object.assign({
                    signal: controller.signal
                }, options));
                clearTimeout(timeoutId);
                if (!response.ok) {
                    throw new Error('HTTP ' + response.status + ': ' + response.statusText);
                }
                const text = await response.text();
                const currentServer = this.getCurrentServer();
                const status = this.serverStatus.get(currentServer);
                if (status) {
                    status.available = true;
                    status.errorCount = 0;
                    status.lastError = null;
                }
                return text;
            } catch (error) {
                lastError = error;
                if (attempt < this.maxRetries - 1) {
                    await this.findAvailableServer();
                    if (url.includes('/in.php')) {
                        url = this.getInUrl() + url.substring(url.indexOf('?'));
                    } else if (url.includes('/res.php')) {
                        url = this.getResUrl() + url.substring(url.indexOf('?'));
                    }
                    await new Promise(resolve => setTimeout(resolve, this.retryDelay));
                }
            }
        }
        throw lastError || new Error('Все попытки запроса исчерпаны');
    }
    static async performHealthCheck() {
        const now = Date.now();
        if (now - this.lastHealthCheck < this.healthCheckInterval) {
            return;
        }
        const healthPromises = [];
        for (let i = 0; i < this.servers.length; i++) {
            const server = this.servers[i];
            healthPromises.push(
                this.checkServerHealth(server).then(isHealthy => ({
                    server: server,
                    isHealthy: isHealthy,
                    isPreferred: this.isPreferredServer(server)
                }))
            );
        }
        const results = await Promise.allSettled(healthPromises);
        const healthyServers = [];
        let preferredHealthy = null;
        for (let i = 0; i < results.length; i++) {
            const result = results[i];
            if (result.status === 'fulfilled' && result.value.isHealthy) {
                healthyServers.push(result.value);
                if (result.value.isPreferred) {
                    preferredHealthy = result.value;
                }
            }
        }
        const currentServer = this.getCurrentServer();
        const currentStatus = this.serverStatus.get(currentServer);
        if (currentStatus && !currentStatus.available && healthyServers.length > 0) {
            const targetServer = preferredHealthy ? preferredHealthy.server : healthyServers[0].server;
            this.currentServerIndex = this.servers.indexOf(targetServer);
        } else if (preferredHealthy && !this.isPreferredServer(currentServer)) {
            this.currentServerIndex = this.servers.indexOf(preferredHealthy.server);
        }
        this.lastHealthCheck = now;
    }
    static verifySystemIntegrity() {
        try {
            this.#verifyServerIntegrity();
            const expectedServers = Object.values(this.allServers);
            for (let i = 0; i < this.servers.length; i++) {
                const server = this.servers[i];
                if (!expectedServers.includes(server)) {
                    throw new Error('Server list compromised');
                }
            }
            return true;
        } catch (error) {
            console.error('System integrity check failed:', error);
            return false;
        }
    }
}
try {
    ApiManager.init();
} catch (error) {
    console.error('Critical error: Failed to initialize API system');
    throw error;
}
setInterval(() => {
    if (!ApiManager.verifySystemIntegrity()) {
        console.error('System integrity compromised, reinitializing...');
        try {
            ApiManager.init();
        } catch (error) {
            console.error('Failed to reinitialize API system');
        }
    }
}, 10 * 60 * 1000);
class Cooki {
    static async getStorageData(key) {
        return new Promise((resolve, reject) => {
            chrome.storage.sync.get(key, result => {
                if (chrome.runtime.lastError) {
                    reject(Error(chrome.runtime.lastError.message));
                } else {
                    resolve(result);
                }
            });
        });
    }
    static async setStorageData(name, val) {
        const d = {};
        d[name] = val;
        return new Promise((resolve, reject) => {
            chrome.storage.sync.set(d, () => {
                if (chrome.runtime.lastError) {
                    reject(Error(chrome.runtime.lastError.message));
                } else {
                    resolve();
                }
            });
        });
    }
}
class CapGuru {
    static key = ses && 'apikey' in ses && ses.apikey != '' ? ses.apikey : '';
    static setKey(key) {
        key = key || '';
        this.key = key;
    }
    static async getBalance() {
        if (this.key == '') { 
            return 0;
        }
        try {
            await ApiManager.performHealthCheck();
            const url = ApiManager.getResUrl() + '?action=getbalance&key=' + this.key;
            const balans = await ApiManager.makeRequest(url);
            let bal = balans.replace(/[^0-9]/g, "");
            if (bal.length > 0) { 
                bal = parseFloat(bal); 
            } else { 
                bal = 0; 
            }
            return bal;
        } catch (error) {
            return 0;
        }
    }
    static isEmpty(str) {
        return (!str || str.length === 0);
    }
    static check_error(res) {
        if (res.includes("WAIT") || res.includes("ERROR")) { 
            return false; 
        } else { 
            return true; 
        }
    }
    static async send(par) {
        par = par || {};
        if (this.key == '') { 
            return "ERROR: BAD_KEY";
        } 
        try {
            await ApiManager.performHealthCheck();
            par.softguru = "154076";
            par.key = this.key;
            const url = ApiManager.getInUrl();
            const res = await ApiManager.makeRequest(url, {
                method: "POST",
                headers: {
                    Accept: "application/json, text/plain, */*",
                    "Content-Type": "application/json"
                },
                body: JSON.stringify(par)
            });
            if (res.includes("OK")) {
                return res.split("|")[1];
            } else if (res.includes("NOT")) {
                return "WAIT";
            }
            return "ERROR: " + res;
        } catch (error) {
            return "ERROR: " + error.message;
        }
    }
    static async get(id) {
        id = id || 0;
        if (this.key == '') { 
            return "ERROR: BAD_KEY";
        } 
        try {
            await ApiManager.performHealthCheck();
            const url = ApiManager.getResUrl() + '?action=get&key=' + this.key + '&id=' + id;
            const res = await ApiManager.makeRequest(url);
            if (res.includes("OK")) {
                return res.split("|")[1];
            } else if (res.includes("NOT")) {
                return "WAIT";
            }
            return "ERROR: " + res;
        } catch (error) {
            return "ERROR: " + error.message;
        }
    }
    static async click(par) {
        par = par || {};
        const self = this;
        return new Promise(async (resolve, reject) => {
            try {
                const d = await self.send(par);
                if ((d.includes("NOT") || d.includes("ERROR")) && !d.includes("notpic")) { 
                    resolve(false);
                    return false;
                } else {
                    const getid = parseFloat(d);
                    await self.delay(5000);
                    const getres = await self.get(getid);
                    if ((getres.includes("NOT") || getres.includes("ERROR")) && !getres.includes("notpic")) { 
                        resolve(false);
                    } else {
                        console.log(getres);
                        resolve(getres);
                    }
                }
            } catch (error) {
                resolve(false);
            }
        });
    }
    static async yandex(typeCap, t1, t2, puzzle) {
        t2 = t2 || "";
        puzzle = puzzle || "";
        const vd = {};
        vd.key = this.key;
        vd.type = "base64";
        if (t2.length > 0) {
            vd.body0 = t1;
            vd.body1 = t2;
        } else {
            vd.body = t1;
        }
        if (typeCap == "figur") {
            vd.click = "oth";
            vd.textinstructions = "yandex";
        } else if (typeCap == "text") {
            vd.vernet = "18";
        } else if (puzzle != "") {
            vd.click = "oth2";
            vd.textinstructions = "puzzlekal-" + puzzle;
        }
        return await this.click(vd);
    }
    static async hcap(par) {
        par = par || {};
        const vd = {};
        vd.key = this.key;
        vd.type = "base64";
        if (Array.isArray(par.b64)) {
            if (par.b64.length > 1) {
                for (let k = 0; k < par.b64.length; k++) {
                    vd["body" + k] = par.b64[k];
                }
                vd.click = "hcap2";
            } else {
                vd.click = "hcap";
                vd.body = par.b64[k];
            }
        } else {
            vd.click = "hcap";
            vd.body = par.b64;
        }
        if (par.b64_exm) { 
            vd.sizex = 10; 
        }
        vd.textinstructions = par.task;
        return await this.click(vd);
    }
    static async tiktok(typeCap, t1, t2) {
        t2 = t2 || "";
        const vd = {};
        vd.key = this.key;
        if (typeCap === "koleso") {
            vd.textinstructions = "koleso";
            vd.click = "geetest";
            vd.method = "base64";
            if (Array.isArray(t1) && t1.length >= 2) {
                vd.body0 = t1[0];
                vd.body1 = t1[1];
            } else if (t2.length > 0) {
                vd.body0 = t1;
                vd.body1 = t2;
            } else {
                console.error("koleso requires 2 images");
                return "ERROR: koleso requires 2 images";
            }
        } else {
            vd.type = "base64";
            if (t2.length > 0) {
                vd.body0 = t1;
                vd.body1 = t2;
            } else {
                vd.body = t1;
            }
            vd.click = "geetest";
            vd.textinstructions = typeCap;
        }
        return await this.click(vd);
    }
    static async binance(par) {
        par = par || {};
        const vd = {};
        vd.key = this.key;
        vd.type = "base64";
        vd.body = par.b64;
        if (par.task == "slider") {
            vd.click = "geetest";
            vd.textinstructions = par.task;
        } else {
            vd.click = "geetest2";
            vd.textinstructions = par.task;
        }
        return await this.click(vd);
    }
    static async recap(par) {
        par = par || {};
        const vd = {};
        vd.key = this.key;
        vd.type = "base64";
        if (Array.isArray(par.b64)) {
            if (par.b64.length > 1) {
                for (let k = 0; k < par.b64.length; k++) {
                    vd["body" + k] = par.b64[k];
                }
                vd.click = "recap2";
            } else {    
                vd.body = par.b64[0];
            }
        } else {
            vd.body = par.b64;
        }
        vd.textinstructions = par.task;
        vd.click = "recap2";
        if (par.setka) { 
            vd.sizex = par.setka; 
        }
        return await this.click(vd);
    }
    static async geetest(par) {
       par = par || {};
       const vd = {};
       vd.key = this.key;
       vd.type = "base64";
       vd.body = par.b64;
       vd.click = "geetest";
       vd.textinstructions = par.task || "slider";
        return await this.click(vd);
    }
    static async funcap(typeCap, img) {
        const vd = {};
        vd.key = this.key;
        vd.type = "base64";
        vd.body = img;
        vd.click = "funcap2";
        vd.textinstructions = typeCap;
        return await this.click(vd);
    }
    static delay(ms) {
        return new Promise(res => setTimeout(res, ms));
    }
}
class Curl2 {
    static async get(t) {
        try {
            if (t.includes('cap.guru')) {
                return await ApiManager.makeRequest(t);
            }
            const response = await fetch(t);
            return await response.text();
        } catch (error) {
            throw error;
        }
    }
    static async post(t, e) {
        e = e || {};
        try {
            if (t.includes('cap.guru')) {
                return await ApiManager.makeRequest(t, {
                    method: "POST",
                    headers: {
                        Accept: "application/json, text/plain, */*",
                        "Content-Type": "application/json"
                    },
                    body: JSON.stringify(e)
                });
            }
            const response = await fetch(t, {
                method: "POST",
                headers: {
                    Accept: "application/json, text/plain, */*",
                    "Content-Type": "application/json"
                },
                body: JSON.stringify(e)
            });
            return await response.text();
        } catch (error) {
            throw error;
        }
    }
}
class ConfigLoader {
    static async loadConfig() {
        try {
            const response = await fetch(chrome.runtime.getURL('config.json'));
            if (!response.ok) {
                throw new Error('HTTP error! status: ' + response.status);
            }
            const config = await response.json();
            return config;
        } catch (error) {
            const lang = getBrowserLanguageInBackground();
            if (lang === 'ru') {
                console.warn('Не удалось загрузить config.json:', error.message);
            } else {
                console.warn('Failed to load config.json:', error.message);
            }
            return null;
        }
    }
    static async applyConfig(config) {
        if (!config) return false;
        try {
            if (config.apikey && config.apikey.trim() !== '') {
                await Cooki.setStorageData('apikey', config.apikey);
                ses.apikey = config.apikey;
                CapGuru.setKey(config.apikey);
            }
            if (config.settings) {
                const settings = config.settings;
                const settingKeys = Object.keys(settings);
                for (let i = 0; i < settingKeys.length; i++) {
                    const setting = settingKeys[i];
                    await Cooki.setStorageData(setting, settings[setting]);
                }
            }
            return true;
        } catch (error) {
            logErrorWithLanguage(error, 'применение конфигурации / config application');
            return false;
        }
    }
}
async function updatebalans(bal) {
    const lang = getBrowserLanguageInBackground();
    let balans = bal != null ? bal : await CapGuru.getBalance();
    await Cooki.setStorageData("balans", balans);
    await Cooki.setStorageData("onoff2", (balans == 0 || balans == '0' ? '0' : '1'));
    if (lang === 'ru') {
        console.log('💰 Баланс обновлен:', balans);
    } else {
        console.log('💰 Balance updated:', balans);
    }
}
async function preloadAllData() {
    if (isPreloading && preloadPromise) {
        return preloadPromise;
    }
    isPreloading = true;
    const lang = getBrowserLanguageInBackground();
    if (lang === 'ru') {
        console.log('🚀 Начинаем предзагрузку данных в background...');
    } else {
        console.log('🚀 Starting data preloading in background...');
    }
    preloadPromise = (async () => {
        try {
            if (lang === 'ru') {
                console.log('📁 Загружаем config.json...');
            } else {
                console.log('📁 Loading config.json...');
            }
            configData = await ConfigLoader.loadConfig();
            if (configData) {
                logSuccessWithLanguage(lang === 'ru' ? 'Config.json загружен' : 'Config.json loaded');
                await ConfigLoader.applyConfig(configData);
            }
            if (lang === 'ru') {
                console.log('💾 Загружаем данные из storage...');
            } else {
                console.log('💾 Loading data from storage...');
            }
            const storagePromises = [
                Cooki.getStorageData("apikey"),
                Cooki.getStorageData("onoff"),
                Cooki.getStorageData("onoff2"),
                Cooki.getStorageData("onoff_repeat"),
                Cooki.getStorageData("tiktok"),
                Cooki.getStorageData("oth"),
                Cooki.getStorageData("hcap"),
                Cooki.getStorageData("recap"),
                Cooki.getStorageData("geetest"),
                Cooki.getStorageData("funcap"),
                Cooki.getStorageData("binance"),
                Cooki.getStorageData("aws"),
                Cooki.getStorageData("balans")
            ];
            const storageResults = await Promise.all(storagePromises);
            const allData = {};
            for (let i = 0; i < storageResults.length; i++) {
                const result = storageResults[i];
                if (result && typeof result === 'object') {
                    const keys = Object.keys(result);
                    for (let j = 0; j < keys.length; j++) {
                        const key = keys[j];
                        allData[key] = result[key];
                    }
                }
            }
            ses = allData;
            if (allData.apikey) {
                if (lang === 'ru') {
                    console.log('💰 Загружаем баланс...');
                } else {
                    console.log('💰 Loading balance...');
                }
                CapGuru.setKey(allData.apikey);
                try {
                    const balance = await CapGuru.getBalance();
                    allData.balans = balance;
                    await updatebalans(balance);
                    if (lang === 'ru') {
                        console.log('✅ Баланс загружен:', balance);
                    } else {
                        console.log('✅ Balance loaded:', balance);
                    }
                } catch (error) {
                    if (lang === 'ru') {
                        console.warn('⚠️ Не удалось загрузить баланс:', error);
                    } else {
                        console.warn('⚠️ Failed to load balance:', error);
                    }
                    allData.balans = 0;
                }
            }
            preloadedData = { received: allData };
            if (lang === 'ru') {
                console.log('🎉 Предзагрузка завершена успешно:', preloadedData);
            } else {
                console.log('🎉 Preloading completed successfully:', preloadedData);
            }
            try {
                chrome.runtime.sendMessage({
                    action: 'dataPreloaded',
                    data: preloadedData,
                    timestamp: Date.now(),
                    language: lang
                }).catch(() => {});
            } catch (error) {}
            return preloadedData;
        } catch (error) {
            logErrorWithLanguage(error, lang === 'ru' ? 'предзагрузка' : 'preloading');
            return null;
        } finally {
            isPreloading = false;
        }
    })();
    return preloadPromise;
}
function utf8ToBase64(str) {
    const encoder = new TextEncoder();
    const utf8Array = encoder.encode(str);
    let binary = '';
    for (let i = 0; i < utf8Array.length; i++) {
        binary += String.fromCharCode(utf8Array[i]);
    }
    return btoa(binary);
}
function convertOctetStreamToPNG(octetStreamData) {
    let base64String = btoa(String.fromCharCode.apply(null, new Uint8Array(octetStreamData)));
    let dataURI = 'data:image/png;base64,' + base64String;
    return dataURI;
}
(async function initializeWithLanguage() {
    const lang = getBrowserLanguageInBackground();
    if (lang === 'ru') {
        console.log('🌍 Язык интерфейса: Русский');
        console.log('🔧 Инициализация Cap.Guru...');
    } else {
        console.log('🌍 Interface language: English');
        console.log('🔧 Initializing Cap.Guru...');
    }
    await preloadAllData();
    setInterval(async function(){ 
        if (ses.apikey) {
            await updatebalans(); 
        }
    }, 300000);
    setInterval(async function(){
        await ApiManager.performHealthCheck();
    }, ApiManager.healthCheckInterval);
    setTimeout(async function(){
        await ApiManager.performHealthCheck();
    }, 10000);
    chrome.runtime.onMessage.addListener((req, sender, sendResponse) => {
        const lang = getBrowserLanguageInBackground();
        if (lang === 'ru') {
            console.log("📨 Получено сообщение:", req);
        } else {
            console.log("📨 Message received:", req);
        }
        if (req === 'getPreloadedData' || (Array.isArray(req) && req[0] === 'getPreloaded')) {
            if (preloadedData) {
                if (lang === 'ru') {
                    console.log('📤 Отправляем предзагруженные данные');
                } else {
                    console.log('📤 Sending preloaded data');
                }
                sendResponse({
                    ...preloadedData,
                    language: lang
                });
            } else {
                if (lang === 'ru') {
                    console.log('⏳ Данные еще загружаются, ждем...');
                } else {
                    console.log('⏳ Data still loading, waiting...');
                }
                if (preloadPromise) {
                    preloadPromise.then(data => {
                        sendResponse({
                            ...(data || { received: {} }),
                            language: lang
                        });
                    });
                } else {
                    preloadAllData().then(data => {
                        sendResponse({
                            ...(data || { received: {} }),
                            language: lang
                        });
                    });
                }
            }
            return true;
        }
        const tt = req[0];
        const dd = req[1];
        let url1, url2;
        CapGuru.setKey(ses.apikey);
        if (tt == "imgs") {
            if (dd['click'] == "tiktok") {
                let url1, url2;
                if (dd['type'] == "koleso") {
                    if (Array.isArray(dd['url']) && dd['url'].length >= 2) {
                        url1 = dd['url'][0];
                        url2 = dd['url'][1];
                        console.log("Processing koleso with 2 images:", {
                            img1_length: url1.length,
                            img2_length: url2.length
                        });
                        CapGuru.tiktok("koleso", url1, url2).then(d => { 
                            console.log("Koleso response:", d);
                            sendResponse({
                                received: d,
                                language: lang
                            }); 
                        });
                    } else {
                        console.error("Koleso requires array of 2 images, got:", typeof dd['url'], Array.isArray(dd['url']) ? dd['url'].length : 'not array');
                        sendResponse({
                            received: "ERROR: koleso requires 2 images",
                            language: lang
                        });
                    }
                } else {
                    if (Array.isArray(dd['url'])) {
                        url1 = dd['url'][0];
                        url2 = dd['url'][1] || "";
                    } else {
                        url1 = dd['url'];
                        url2 = "";
                    }
                    console.log("Processing TikTok type:", dd['type'], {
                        img1_length: url1 ? url1.length : 0,
                        img2_length: url2 ? url2.length : 0
                    });
                    CapGuru.tiktok(dd['type'], url1, url2).then(d => { 
                        console.log("TikTok response:", d);
                        sendResponse({
                            received: d,
                            language: lang
                        }); 
                    });
                }
            } else if (dd['click'] == "geetest") {
                CapGuru.geetest({"task": dd['type'], "b64": dd['url']}).then(d => { 
                    sendResponse({
                        received: d,
                        language: lang
                    }); 
                });
            } else if (dd['click'] == "hcap") {
                CapGuru.hcap({"task": dd['type'], "b64": dd['url'], "b64_exm": dd['exm']}).then(d => { 
                    sendResponse({
                        received: d,
                        language: lang
                    }); 
                });
            } else if (dd['click'] == "ya") {
                if (Array.isArray(dd['url'])) {
                    url1 = dd['url'][0];
                    url2 = dd['url'][1];
                } else {
                    url1 = dd['url'];
                    url2 = "";
                }
                let puzzle = "";
                if ("puzzle" in dd) { 
                    puzzle = dd['puzzle']; 
                }
                CapGuru.yandex(dd['type'], url1, url2, puzzle).then(d => { 
                    sendResponse({
                        received: d,
                        language: lang
                    }); 
                });
            } else if (dd['click'] == "recap") {
                CapGuru.recap({"task": dd['type'], "b64": dd['url'], "setka": dd['setka']}).then(d => { 
                    sendResponse({
                        received: d,
                        language: lang
                    }); 
                });
            } else if (dd['click'] == "binance") {
                CapGuru.binance({"task": dd['type'], "b64": dd['url']}).then(d => { 
                    sendResponse({
                        received: d,
                        language: lang
                    }); 
                });
            } else if (dd['click'] == "funcap") {
                CapGuru.funcap(dd['type'], dd['url']).then(d => { 
                    sendResponse({
                        received: d,
                        language: lang
                    }); 
                });
            }
        } else if (tt == "set" || tt == "get") {
            let newKey = false;
            if (tt == "set") {
                if (dd['n'] == "apikey") { 
                    newKey = true; 
                    ses.apikey = dd['v'];  
                    CapGuru.setKey(ses.apikey); 
                }
                Cooki.setStorageData(dd['n'], dd['v']); 
                if (preloadedData && preloadedData.received) {
                    preloadedData.received[dd['n']] = dd['v'];
                }
                sendResponse({
                    received: 'OK',
                    language: lang
                });
                if (dd['n'] == "onoff_repeat") { 
                    return true; 
                }
            }
            try {
                const th = [];
                if (newKey) { 
                    th.push(CapGuru.getBalance()); 
                }
                th.push(Cooki.getStorageData("apikey"));
                th.push(Cooki.getStorageData("onoff"));
                th.push(Cooki.getStorageData("onoff2"));
                th.push(Cooki.getStorageData("onoff_repeat"));
                th.push(Cooki.getStorageData("tiktok"));
                th.push(Cooki.getStorageData("oth"));
                th.push(Cooki.getStorageData("hcap"));
                th.push(Cooki.getStorageData("recap"));
                th.push(Cooki.getStorageData("geetest"));
                th.push(Cooki.getStorageData("funcap"));
                th.push(Cooki.getStorageData("binance"));
                th.push(Cooki.getStorageData("aws"));
                th.push(Cooki.getStorageData("balans"));
                Promise.all(th).then((values) => {
                    if (lang === 'ru') {
                        console.log('💰 Баланс:', values);
                    } else {
                        console.log('💰 Balance:', values);
                    }
                    const balans2 = values[0];
                    setTimeout(function() {
                        const vlse = {};
                        if (newKey) { 
                            updatebalans(balans2);
                            values.shift();
                        }
                        for (let k = 0; k < values.length; k++) {
                            if (values[k] != undefined && values[k] != '') {
                                const keys = Object.keys(values[k]);
                                for (let k2 = 0; k2 < keys.length; k2++) {
                                    const key = keys[k2];
                                    vlse[key] = values[k][key];
                                }
                            }
                        }
                        if (balans2 == '0' || balans2 == 0) { 
                            vlse['onoff2'] = '0'; 
                        }
                        ses = vlse;
                        preloadedData = { received: vlse };
                        sendResponse({
                            received: vlse,
                            language: lang
                        });
                    }, 100);
                });
            } catch (e) {
                logErrorWithLanguage(e, 'обработка сообщений / message handling');
            }
        } else if (tt == "fetch") {
            let url23;
            fetch(dd['url'], { mode: 'cors' })
            .then(response => { 
                url23 = response.url; 
                console.log(); 
                return response.blob(); 
            })
            .then(blob => {
                const reader = new FileReader();
                reader.onloadend = () => sendResponse({ 
                    received: reader.result.split(',')[1], 
                    url: url23,
                    language: lang
                });
                reader.readAsDataURL(blob);
            })
            .catch(error => {
                logErrorWithLanguage(error, 'fetch image');
                sendResponse({
                    received: null,
                    error: error.message,
                    language: lang
                });
            });
        }
        return true;
    });
    if (lang === 'ru') {
        console.log('✅ Cap.Guru инициализирован успешно');
    } else {
        console.log('✅ Cap.Guru initialized successfully');
    }
})();