let capUse = false;
let capUseCount = 0;
let onoffk1 = false, onoffk2 = false;




try {
    Object.defineProperty(navigator, 'webdriver', {
        get: () => undefined,
        configurable: true
    });
} catch(e) {}


try {
    delete window.chrome;
    delete window.navigator.chrome;
} catch(e) {}


const HUMAN_PROFILES = [
    {
        mouseSpeed: 400,
        reactionTime: [300, 900],
        accuracy: 0.95,
        hesitation: 0.3,
        typingSpeed: [80, 200]
    },
    {
        mouseSpeed: 1200,
        reactionTime: [100, 400],
        accuracy: 0.85,
        hesitation: 0.15,
        typingSpeed: [30, 100]
    },
    {
        mouseSpeed: 800,
        reactionTime: [200, 600],
        accuracy: 0.9,
        hesitation: 0.2,
        typingSpeed: [50, 150]
    }
];

const CURRENT_PROFILE = HUMAN_PROFILES[Math.floor(Math.random() * HUMAN_PROFILES.length)];
let sessionFatigue = 0;

function getCurrentProfile() {
    const fatigueFactor = Math.min(sessionFatigue / 100, 0.3);
    return {
        mouseSpeed: CURRENT_PROFILE.mouseSpeed * (1 - fatigueFactor * 0.5),
        reactionTime: [
            CURRENT_PROFILE.reactionTime[0] * (1 + fatigueFactor),
            CURRENT_PROFILE.reactionTime[1] * (1 + fatigueFactor * 0.5)
        ],
        accuracy: CURRENT_PROFILE.accuracy * (1 - fatigueFactor * 0.2),
        hesitation: CURRENT_PROFILE.hesitation * (1 + fatigueFactor),
        typingSpeed: [
            CURRENT_PROFILE.typingSpeed[0] * (1 + fatigueFactor * 0.5),
            CURRENT_PROFILE.typingSpeed[1] * (1 + fatigueFactor)
        ]
    };
}



function secureRandom() {
    if (window.crypto && window.crypto.getRandomValues) {
        const arr = new Uint32Array(1);
        window.crypto.getRandomValues(arr);
        return arr[0] / 4294967296;
    }
    return Math.random();
}

function randomGaussian(mean = 0, std = 1) {
    let u = 0, v = 0;
    while (u === 0) u = secureRandom();
    while (v === 0) v = secureRandom();
    const z = Math.sqrt(-2.0 * Math.log(u)) * Math.cos(2.0 * Math.PI * v);
    return z * std + mean;
}

function randomLogNormal(mean, sigma) {
    const normal = randomGaussian(0, 1);
    return Math.exp(mean + sigma * normal);
}



async function humanDelay(type = 'reaction') {
    const profile = getCurrentProfile();
    let delay;
    
    switch(type) {
        case 'reaction':
            delay = randomLogNormal(5.5, 0.4);
            delay = Math.max(profile.reactionTime[0], Math.min(profile.reactionTime[1], delay));
            break;
        case 'decision':
            if (secureRandom() < 0.7) {
                delay = randomGaussian(400, 100);
            } else {
                delay = randomGaussian(1200, 300);
            }
            break;
        case 'typing':
            const base = randomLogNormal(4.2, 0.3);
            delay = Math.max(profile.typingSpeed[0], Math.min(profile.typingSpeed[1], base));
            break;
        case 'reading':
            delay = randomGaussian(800, 200);
            break;
        case 'micro':
            delay = randomGaussian(50, 20);
            break;
        default:
            delay = randomGaussian(300, 100);
    }
    
    const jitter = randomGaussian(0, delay * 0.05);
    const finalDelay = Math.max(16, Math.floor(delay + jitter));
    
    await new Promise(resolve => setTimeout(resolve, finalDelay));
    sessionFatigue += 0.1;
}



let lastPointerId = Math.floor(secureRandom() * 1000);
function getNextPointerId() {
    lastPointerId = (lastPointerId + Math.floor(secureRandom() * 3) + 1) % 10000;
    return lastPointerId;
}

const mouseHistory = {
    x: window.innerWidth / 2,
    y: window.innerHeight / 2,
    timestamp: Date.now(),
    path: []
};

function updateMouseHistory(x, y) {
    const now = Date.now();
    const timeDelta = now - mouseHistory.timestamp;
    
    mouseHistory.path.push({
        x: mouseHistory.x,
        y: mouseHistory.y,
        time: mouseHistory.timestamp
    });
    
    if (mouseHistory.path.length > 10) {
        mouseHistory.path.shift();
    }
    
    mouseHistory.x = x;
    mouseHistory.y = y;
    mouseHistory.timestamp = now;
    
    return timeDelta;
}

function getScreenProps() {
    const dpr = window.devicePixelRatio || 1;
    return {
        screenX: Math.floor(mouseHistory.x * dpr + randomGaussian(0, 0.5)),
        screenY: Math.floor(mouseHistory.y * dpr + randomGaussian(0, 0.5)),
        clientX: mouseHistory.x,
        clientY: mouseHistory.y,
        movementX: mouseHistory.path.length > 1 
            ? mouseHistory.x - mouseHistory.path[mouseHistory.path.length - 2].x 
            : 0,
        movementY: mouseHistory.path.length > 1 
            ? mouseHistory.y - mouseHistory.path[mouseHistory.path.length - 2].y 
            : 0
    };
}



function buildYandexTaskUrl(url) {
    try {
        if (!url || typeof url !== 'string') return '';
        
        
        if (/([?&])(?:b?data)=task\b/i.test(url)) return url;
        if (/([?&])(?:b?data)=img\b/i.test(url)) {
            return url.replace(/([?&])((?:b)?data)=img\b/i, '$1$2=task');
        }
        
        const sep = url.includes('?') ? '&' : '?';
        return url + sep + 'data=task';
    } catch (e) {
        return '';
    }
}



class HumanMovement {
    constructor() {
        this.velocity = { x: 0, y: 0 };
        this.acceleration = { x: 0, y: 0 };
    }
    
    calculateTrajectory(start, end, duration) {
        const distance = Math.hypot(end.x - start.x, end.y - start.y);
        const profile = getCurrentProfile();
        
        const fittsTime = duration * Math.log2(distance / 10 + 1);
        const actualDuration = fittsTime * (1 + randomGaussian(0, 0.1));
        
        const points = [];
        const steps = Math.max(30, Math.floor(actualDuration / 16));
        
        const curvature = randomGaussian(0, distance * 0.15);
        const perpAngle = Math.atan2(end.y - start.y, end.x - start.x) + Math.PI / 2;
        
        const controlPoint1 = {
            x: start.x + (end.x - start.x) * 0.3 + Math.cos(perpAngle) * curvature,
            y: start.y + (end.y - start.y) * 0.3 + Math.sin(perpAngle) * curvature
        };
        
        const controlPoint2 = {
            x: start.x + (end.x - start.x) * 0.7 + Math.cos(perpAngle) * curvature * 0.3,
            y: start.y + (end.y - start.y) * 0.7 + Math.sin(perpAngle) * curvature * 0.3
        };
        
        for (let i = 0; i <= steps; i++) {
            const t = i / steps;
            const jerkT = this.minimumJerk(t);
            
            const pos = this.cubicBezier(jerkT, start, controlPoint1, controlPoint2, end);
            
            const tremor = this.calculateTremor(t, steps);
            
            const noise = {
                x: randomGaussian(0, 0.5),
                y: randomGaussian(0, 0.5)
            };
            
            points.push({
                x: pos.x + tremor.x + noise.x,
                y: pos.y + tremor.y + noise.y,
                t: t,
                timestamp: Date.now() + (actualDuration * t)
            });
        }
        
        return points;
    }
    
    minimumJerk(t) {
        return 10 * Math.pow(t, 3) - 15 * Math.pow(t, 4) + 6 * Math.pow(t, 5);
    }
    
    cubicBezier(t, p0, p1, p2, p3) {
        const cX = 3 * (p1.x - p0.x);
        const bX = 3 * (p2.x - p1.x) - cX;
        const aX = p3.x - p0.x - cX - bX;
        
        const cY = 3 * (p1.y - p0.y);
        const bY = 3 * (p2.y - p1.y) - cY;
        const aY = p3.y - p0.y - cY - bY;
        
        const x = (aX * Math.pow(t, 3)) + (bX * Math.pow(t, 2)) + (cX * t) + p0.x;
        const y = (aY * Math.pow(t, 3)) + (bY * Math.pow(t, 2)) + (cY * t) + p0.y;
        
        return { x, y };
    }
    
    calculateTremor(t, totalSteps) {
        const frequency = 10 + randomGaussian(0, 1);
        const amplitude = 0.5 + Math.sin(t * Math.PI) * 0.5;
        
        const phase = t * Math.PI * 2 * frequency;
        return {
            x: Math.cos(phase) * amplitude * randomGaussian(1, 0.2),
            y: Math.sin(phase) * amplitude * randomGaussian(1, 0.2)
        };
    }
}

const movementEngine = new HumanMovement();



async function humanMoveTo(element, targetX, targetY, options = {}) {
    const rect = element.getBoundingClientRect();
    const startX = options.startX || mouseHistory.x;
    const startY = options.startY || mouseHistory.y;
    
    const target = {
        x: rect.left + targetX,
        y: rect.top + targetY
    };
    
    const profile = getCurrentProfile();
    const distance = Math.hypot(target.x - startX, target.y - startY);
    const baseDuration = (distance / profile.mouseSpeed) * 1000;
    
    const willOvershoot = secureRandom() > profile.accuracy;
    let actualTarget = { ...target };
    let overshootReturn = false;
    
    if (willOvershoot && !options.noOvershoot) {
        const overshootDist = randomLogNormal(3, 0.5);
        const angle = Math.atan2(target.y - startY, target.x - startX);
        actualTarget.x += Math.cos(angle) * overshootDist;
        actualTarget.y += Math.sin(angle) * overshootDist;
        overshootReturn = true;
    }
    
    const points = movementEngine.calculateTrajectory(
        { x: startX, y: startY },
        actualTarget,
        baseDuration
    );
    
    for (let i = 0; i < points.length; i++) {
        const point = points[i];
        updateMouseHistory(point.x, point.y);
        const screenProps = getScreenProps();
        
        const event = new MouseEvent('mousemove', {
            bubbles: true,
            cancelable: true,
            view: window,
            detail: 0,
            screenX: screenProps.screenX,
            screenY: screenProps.screenY,
            clientX: point.x,
            clientY: point.y,
            ctrlKey: false,
            altKey: false,
            shiftKey: false,
            metaKey: false,
            button: 0,
            buttons: 0,
            relatedTarget: element,
            movementX: screenProps.movementX,
            movementY: screenProps.movementY
        });
        
        Object.defineProperty(event, 'timeStamp', {
            value: point.timestamp,
            writable: false
        });
        
        element.dispatchEvent(event);
        
        if (secureRandom() < profile.hesitation && i > points.length * 0.5 && i < points.length * 0.8) {
            await humanDelay('micro');
        }
        
        if (i < points.length - 1) {
            const nextPoint = points[i + 1];
            const waitTime = nextPoint.timestamp - point.timestamp;
            const jitteredWait = waitTime * (1 + randomGaussian(0, 0.1));
            await new Promise(r => setTimeout(r, Math.max(0, jitteredWait)));
        }
    }
    
    if (overshootReturn) {
        await humanDelay('micro');
        const returnPoints = movementEngine.calculateTrajectory(
            actualTarget,
            target,
            randomGaussian(150, 50)
        );
        
        for (const point of returnPoints) {
            updateMouseHistory(point.x, point.y);
            const screenProps = getScreenProps();
            
            const event = new MouseEvent('mousemove', {
                bubbles: true,
                cancelable: true,
                view: window,
                screenX: screenProps.screenX,
                screenY: screenProps.screenY,
                clientX: point.x,
                clientY: point.y,
                movementX: screenProps.movementX,
                movementY: screenProps.movementY
            });
            
            element.dispatchEvent(event);
            await new Promise(r => setTimeout(r, 16));
        }
    }
    
    return { x: target.x, y: target.y };
}

async function humanClick(element, options = {}) {
    if (typeof element === 'string') {
        element = document.querySelector(element);
    }
    
    if (!element) return false;
    
    const rect = element.getBoundingClientRect();
    const profile = getCurrentProfile();
    
    const marginX = rect.width * 0.15;
    const marginY = rect.height * 0.15;
    const targetX = marginX + secureRandom() * (rect.width - marginX * 2);
    const targetY = marginY + secureRandom() * (rect.height - marginY * 2);
    
    // Пропускаем decision delay если передан флаг skipInitialDelay
    if (!options.skipInitialDelay) {
        await humanDelay('decision');
    }
    await humanMoveTo(element, targetX, targetY, options);
    await humanDelay('reaction');
    
    if (secureRandom() < 0.6) {
        const adjustX = targetX + randomGaussian(0, 2);
        const adjustY = targetY + randomGaussian(0, 2);
        await humanMoveTo(element, adjustX, adjustY, { noOvershoot: true });
        await humanDelay('micro');
    }
    
    const preClickX = mouseHistory.x + randomGaussian(0, 0.5);
    const preClickY = mouseHistory.y + randomGaussian(0, 0.5);
    
    const events = [
        { type: 'mouseover', time: 0 },
        { type: 'mouseenter', time: randomGaussian(10, 3) },
        { type: 'mousemove', time: randomGaussian(20, 5) },
        { type: 'mousedown', time: randomGaussian(100, 30) },
        { type: 'mouseup', time: randomLogNormal(4.5, 0.3) },
        { type: 'click', time: randomGaussian(20, 5) }
    ];
    
    for (const evt of events) {
        await new Promise(r => setTimeout(r, Math.max(0, evt.time)));
        
        const screenProps = getScreenProps();
        const pointerId = getNextPointerId();
        
        if (['mousedown', 'mouseup'].includes(evt.type) || secureRandom() > 0.3) {
            const pointerType = evt.type === 'mousedown' ? 'pointerdown' : 
                               evt.type === 'mouseup' ? 'pointerup' : 'pointermove';
            
            const pointerEvent = new PointerEvent(pointerType, {
                bubbles: true,
                cancelable: true,
                view: window,
                detail: evt.type === 'click' ? 1 : 0,
                screenX: screenProps.screenX,
                screenY: screenProps.screenY,
                clientX: preClickX,
                clientY: preClickY,
                ctrlKey: false,
                altKey: false,
                shiftKey: false,
                metaKey: false,
                button: evt.type === 'mousedown' ? 0 : -1,
                buttons: evt.type === 'mousedown' ? 1 : 0,
                relatedTarget: null,
                pointerId: pointerId,
                width: 1 + secureRandom(),
                height: 1 + secureRandom(),
                pressure: evt.type === 'mousedown' ? 0.5 + secureRandom() * 0.3 : 0,
                tiltX: randomGaussian(0, 5),
                tiltY: randomGaussian(0, 5),
                pointerType: 'mouse',
                isPrimary: true
            });
            
            element.dispatchEvent(pointerEvent);
        }
        
        const mouseEvent = new MouseEvent(evt.type, {
            bubbles: true,
            cancelable: true,
            view: window,
            detail: evt.type === 'click' ? 1 : 0,
            screenX: screenProps.screenX,
            screenY: screenProps.screenY,
            clientX: preClickX,
            clientY: preClickY,
            ctrlKey: false,
            altKey: false,
            shiftKey: false,
            metaKey: false,
            button: evt.type === 'mousedown' ? 0 : -1,
            buttons: evt.type === 'mousedown' ? 1 : 0,
            relatedTarget: null,
            movementX: 0,
            movementY: 0
        });
        
        element.dispatchEvent(mouseEvent);
        
        if (evt.type === 'mousedown' && (element.tagName === 'INPUT' || element.tagName === 'TEXTAREA')) {
            element.focus();
            element.dispatchEvent(new FocusEvent('focus', { bubbles: true }));
        }
    }
    
    if (secureRandom() < 0.4) {
        await humanDelay('micro');
        const moveAwayX = targetX + randomGaussian(30, 10);
        const moveAwayY = targetY + randomGaussian(20, 10);
        await humanMoveTo(element, moveAwayX, moveAwayY, { noOvershoot: true });
    }
    
    return true;
}

async function humanDrag(element, distance, options = {}) {
    if (typeof element === 'string') {
        element = document.querySelector(element);
    }
    
    if (!element) return false;
    
    const rect = element.getBoundingClientRect();
    const startX = rect.left + rect.width / 2;
    const startY = rect.top + rect.height / 2;
    
    await humanMoveTo(element, 0, 0, { startX: mouseHistory.x, startY: mouseHistory.y });
    await humanDelay('reaction');
    
    const grabX = mouseHistory.x;
    const grabY = mouseHistory.y;
    
    const pointerDown = new PointerEvent('pointerdown', {
        bubbles: true,
        cancelable: true,
        pointerId: getNextPointerId(),
        pointerType: 'mouse',
        clientX: grabX,
        clientY: grabY,
        pressure: 0.8,
        buttons: 1
    });
    element.dispatchEvent(pointerDown);
    
    const mousedown = new MouseEvent('mousedown', {
        bubbles: true,
        cancelable: true,
        clientX: grabX,
        clientY: grabY,
        button: 0,
        buttons: 1
    });
    element.dispatchEvent(mousedown);
    
    await humanDelay('micro');
    
    const profile = getCurrentProfile();
    const steps = Math.floor(distance / 2) + Math.floor(randomGaussian(20, 5));
    const targetX = startX + distance;
    
    const willOverdrag = secureRandom() < 0.2;
    const actualTargetX = willOverdrag ? targetX + randomGaussian(20, 10) : targetX;
    
    for (let i = 0; i <= steps; i++) {
        const progress = i / steps;
        
        const easedProgress = progress < 0.5 
            ? 2 * progress * progress 
            : 1 - Math.pow(-2 * progress + 2, 2) / 2;
        
        let currentX = startX + (actualTargetX - startX) * easedProgress;
        let currentY = startY + randomGaussian(0, 2);
        
        if (progress > 0.8 && willOverdrag) {
            currentX = targetX + (actualTargetX - targetX) * (1 - (progress - 0.8) / 0.2);
        }
        
        updateMouseHistory(currentX, currentY);
        const screenProps = getScreenProps();
        
        const moveEvent = new MouseEvent('mousemove', {
            bubbles: true,
            cancelable: true,
            clientX: currentX,
            clientY: currentY,
            screenX: screenProps.screenX,
            screenY: screenProps.screenY,
            movementX: screenProps.movementX,
            movementY: screenProps.movementY,
            buttons: 1
        });
        
        element.dispatchEvent(moveEvent);
        
        const speedFactor = 1 + Math.sin(progress * Math.PI) * 0.5;
        await new Promise(r => setTimeout(r, (16 / speedFactor) + randomGaussian(0, 2)));
        
        if (secureRandom() < 0.03) {
            await humanDelay('micro');
        }
    }
    
    await humanDelay('micro');
    
    const pointerUp = new PointerEvent('pointerup', {
        bubbles: true,
        cancelable: true,
        pointerId: getNextPointerId(),
        pointerType: 'mouse',
        clientX: mouseHistory.x,
        clientY: mouseHistory.y,
        pressure: 0
    });
    element.dispatchEvent(pointerUp);
    
    const mouseup = new MouseEvent('mouseup', {
        bubbles: true,
        cancelable: true,
        clientX: mouseHistory.x,
        clientY: mouseHistory.y,
        button: 0
    });
    element.dispatchEvent(mouseup);
    
    return true;
}

async function humanType(element, text) {
    if (typeof element === 'string') {
        element = document.querySelector(element);
    }
    
    if (!element) return;
    
    await humanClick(element);
    await humanDelay('decision');
    
    if (element.value && element.value.length > 0) {
        const selectAll = new KeyboardEvent('keydown', {
            key: 'a',
            code: 'KeyA',
            ctrlKey: true,
            bubbles: true
        });
        element.dispatchEvent(selectAll);
        element.setSelectionRange(0, element.value.length);
        
        await humanDelay('micro');
        
        const backspace = new KeyboardEvent('keydown', {
            key: 'Backspace',
            code: 'Backspace',
            keyCode: 8,
            bubbles: true
        });
        element.dispatchEvent(backspace);
        element.value = '';
        
        const backspaceUp = new KeyboardEvent('keyup', {
            key: 'Backspace',
            code: 'Backspace',
            keyCode: 8,
            bubbles: true
        });
        element.dispatchEvent(backspaceUp);
        
        await humanDelay('micro');
    }
    
    const chars = text.split('');
    let consecutiveCorrect = 0;
    
    for (let i = 0; i < chars.length; i++) {
        const char = chars[i];
        
        const errorChance = Math.min(0.05, consecutiveCorrect * 0.01);
        
        if (secureRandom() < errorChance && char.match(/[a-zA-Zа-яА-Я]/)) {
            const wrongChar = String.fromCharCode(
                char.charCodeAt(0) + Math.floor(randomGaussian(0, 3))
            );
            await typeChar(element, wrongChar);
            consecutiveCorrect = 0;
            
            await humanDelay('decision');
            await typeChar(element, 'Backspace', true);
            await humanDelay('typing');
        }
        
        await typeChar(element, char);
        consecutiveCorrect++;
        
        if (char === ' ' || char === '.' || char === ',') {
            await humanDelay('reaction');
        } else {
            await humanDelay('typing');
        }
        
        if (secureRandom() < 0.05) {
            await humanDelay('decision');
        }
    }
    
    await humanDelay('reaction');
}

async function typeChar(element, char, isBackspace = false) {
    const actualChar = isBackspace ? '' : char;
    const code = isBackspace ? 'Backspace' : 'Key' + char.toUpperCase();
    const keyCode = isBackspace ? 8 : char.charCodeAt(0);
    
    if (!isBackspace) {
        const start = element.selectionStart || element.value.length;
        const end = element.selectionEnd || start;
        element.value = element.value.slice(0, start) + char + element.value.slice(end);
        element.selectionStart = element.selectionEnd = start + 1;
    } else {
        element.value = element.value.slice(0, -1);
    }
    
    const keydown = new KeyboardEvent('keydown', {
        key: char,
        code: code,
        keyCode: keyCode,
        which: keyCode,
        bubbles: true,
        cancelable: true,
        ctrlKey: false,
        altKey: false,
        shiftKey: char !== char.toLowerCase(),
        metaKey: false,
        repeat: false,
        isComposing: false
    });
    element.dispatchEvent(keydown);
    
    if (!isBackspace) {
        const keypress = new KeyboardEvent('keypress', {
            key: char,
            charCode: keyCode,
            keyCode: keyCode,
            which: keyCode,
            bubbles: true,
            cancelable: true
        });
        element.dispatchEvent(keypress);
    }
    
    const input = new InputEvent('input', {
        bubbles: true,
        cancelable: true,
        inputType: isBackspace ? 'deleteContentBackward' : 'insertText',
        data: isBackspace ? null : char,
        isComposing: false
    });
    element.dispatchEvent(input);
    
    await new Promise(r => setTimeout(r, randomGaussian(10, 3)));
    
    const keyup = new KeyboardEvent('keyup', {
        key: char,
        code: code,
        keyCode: keyCode,
        which: keyCode,
        bubbles: true,
        cancelable: true,
        ctrlKey: false,
        altKey: false,
        shiftKey: char !== char.toLowerCase(),
        metaKey: false,
        repeat: false
    });
    element.dispatchEvent(keyup);
}



document.addEventListener('DOMContentLoaded', async function() {
    mouseHistory.x = randomGaussian(window.innerWidth / 2, 100);
    mouseHistory.y = randomGaussian(window.innerHeight / 2, 100);

    async function tick() {
        try {
            let gdpr = document.querySelector('#gdpr-popup-v3-button-all');
            if (gdpr && isVisible(gdpr)) {
                await humanDelay('reaction');
                await humanClick(gdpr);
                await new Promise(r => setTimeout(r, 500));
            }
        } catch(e) {}
        
        let onoffk1 = !await onoff('oth');
        if (onoffk1) { 
            if (onoffk2 == onoffk1) return false; 
            log("Plugin OFF");
            onoffk2 = onoffk1;
            return false;
        } else { 
            if (onoffk2 != onoffk1) capUse = false;
            onoffk2 = false; 
        }
        
        let el = document.querySelector(".CheckboxCaptcha-Anchor, .AdvancedCaptcha_silhouette, .AdvancedCaptcha, .SliderCaptcha-Inner");
        
        if (el && isVisible(el)) {
            if (!capUse) {
                capUse = true;
                await eStart();
            }
        }
    }

    // Первый тик через 500мс, затем каждые 2000мс
    setTimeout(tick, 500);
    setInterval(tick, 2000);
});

async function eStart() {
    let form1 = 0, form2 = 0, form3 = 0, form4 = 0, form5 = 0, form6 = 0;
    
    let el;
    el = document.querySelector(".CheckboxCaptcha-Anchor"); 
    if (el && isVisible(el)) form1 = 1;
    el = document.querySelector(".CaptchaSlider"); 
    if (el && isVisible(el)) form2 = 1;
    el = document.querySelector(".AdvancedCaptcha-ImageWrapper"); 
    if (el && isVisible(el)) form3 = 1;
    el = document.querySelector(".AdvancedCaptcha_kaleidoscope"); 
    if (el && isVisible(el)) form4 = 1;
    el = document.querySelector(".AdvancedCaptcha-View>img"); 
    if (el && isVisible(el)) form5 = 1;
    
    if (form1 == 0 && form2 == 0 && form3 == 0 && form4 == 0 && form5 == 0) { 
        log("Не нашли следов капчи!");   
        return false; 
    }
    
    for (let i = 0; i < 5; i++) { 
        if (!await onoff('oth')) { 
            log("Plugin OFF in cycle");  
            return false; 
        }
        
        log(form1, form2, form3, form4, form5, form6);
        
        if ((form1 > 0 || form2 > 0) && form3 == 0 && form4 == 0 && form5 == 0) {
            if (form1 > 0) {
                el = document.querySelector(".CheckboxCaptcha-Anchor");
                if (el.className.indexOf("pending") === -1) {
                    // Пауза 500–800мс вместо 2000мс
                    await new Promise(r => setTimeout(r, 500 + Math.floor(secureRandom() * 300)));
                    await humanClick(".CheckboxCaptcha-Anchor input", { skipInitialDelay: true });
                } else {
                    log("Complete click");
                    return true;
                }
            } else if (form2 > 0) {
                el = document.querySelector(".CaptchaSlider");
                let box = el.getBoundingClientRect();
                await humanDrag(".CaptchaSlider .Thumb", box.width);
                await new Promise(r => setTimeout(r, 2000));
            }
            form1 = 0;
            form2 = 0;
            form6 = 1;
        }
        
        if (form3 > 0 || form4 > 0 || form5 > 0 || form6 > 0) {
            el = document.querySelector(".AdvancedCaptcha-ImageWrapper"); 
            if (el && isVisible(el)) { form3 = 1; }
            el = document.querySelector(".AdvancedCaptcha_kaleidoscope"); 
            if (el && isVisible(el)) { form4 = 1; }
            el = document.querySelector(".AdvancedCaptcha-View>img"); 
            if (el && isVisible(el)) { form5 = 1; }
            
            let task = "";
            let imgList = [];
            let puzzle = "";
            
            if (form3 > 0) {
                task = "figur";
                el = document.querySelector(".AdvancedCaptcha-ImageWrapper img");
                
                
                let img4 = await getBase64FromImageUrlYa(el.src, 2);
                let img1 = img4 && img4[0] ? img4[0] : "";
                const finalUrl = img4 && img4[1] ? img4[1] : el.src;
                const url2 = buildYandexTaskUrl(finalUrl);

                let img2 = "";
                if (url2) {
                    img2 = await getBase64FromImageUrlYa(url2);
                }

                
                if (!img2) {
                    try {
                        const canvasEl = document.querySelector(".AdvancedCaptcha-CanvasContainer canvas");
                        if (canvasEl) {
                            img2 = canvasEl.toDataURL().split(",")[1];
                        }
                    } catch (e) {
                        img2 = "";
                    }
                }

                if (!img1 || !img2) {
                    log('YandexSmartCaptcha: failed to extract images (img/task)');
                    return false;
                }

                imgList.push(img1);
                imgList.push(img2);
                
            } else if (form5 > 0) {
                task = "text";
                el = document.querySelector(".AdvancedCaptcha-View>img");
                let img1 = await getBase64FromImageUrlYa(el.src);
                imgList = img1;
            } else if (form4 > 0) {
                task = "puzzle";
                let bodyS = window.document.body ? window.document.body.innerHTML : "";
                let parsed = null;
                try {
                    if (window.__SSR_DATA__) {
                        parsed = window.__SSR_DATA__;
                    }
                } catch(e) {}
                
                if (parsed && parsed.imageSrc && parsed.task) {
                    puzzle = Array.isArray(parsed.task) ? parsed.task.join(',') : String(parsed.task);
                    imgList = await getBase64FromImageUrlYa(parsed.imageSrc);
                } else {
                    let matTask = bodyS.match(/"task"\s*:\s*\[([^\]]+)\]/i) || bodyS.match(/\[([0-9\,\s]+)\]/i);
                    let matImg = bodyS.match(/"imageSrc"\s*:\s*"(.*?)"/i) || bodyS.match(/\,imageSrc\:\"(.*?)\"/i);
                    if (matTask && matImg) {
                        puzzle = String(matTask[1]).replace(/\s+/g, '').replace(/[^0-9,]/g, '');
                        imgList = await getBase64FromImageUrlYa(matImg[1]);
                    } else {
                        log("Not solved sorry", task);
                        return false;
                    }
                }
            }
            
            let res = await sendChrome.X('imgs', {
                'click': "ya", 
                "type": task, 
                'url': imgList, 
                'puzzle': puzzle
            });
            
            console.log("res", res);
            
            if (res && 'received' in res && res['received'] && res['received'] != '' 
                && res['received'] != 'WAIT' && !hasSrt(res['received'], 'ERROR')) {        
                
                let res1 = res['received'];
                
                if (task == "figur") {
                    res1 = res1.replace(/[^0-9,\;]/g, "");
                    let res2 = res1.split(";");
                    
                    for (let k in res2) {
                        let wq = res2[k].split(",");
                        let xp = parseInt(wq[0]), yp = parseInt(wq[1]);
                        
                        await humanDelay('decision');
                        await humanClickOnCanvas(xp, yp);
                    }
                    
                    await new Promise(r => setTimeout(r, 2000));
                    
                    el = document.querySelector("button[data-testid=\"submit\"]");
                    if (el) { 
                        await humanClick(el);
                        await new Promise(r => setTimeout(r, 3000));
                    }
                    
                } else if (task == "text") {
                    el = document.querySelector(".Textinput-Control");
                    await humanType(el, res1);
                    
                    await new Promise(r => setTimeout(r, 2000));
                    simulateEnterPress(".Textinput-Control");
                    log("Click");
                    await new Promise(r => setTimeout(r, 3000));

                } else if (task == "puzzle") {
                    res1 = parseInt(res1);
                    el = document.querySelector(".CaptchaSlider");
                    let bowWidth = el.getBoundingClientRect();
                    let bowWidth2 = bowWidth.width;
                    el = document.querySelector(".CaptchaSlider .Thumb");
                    
                    if (el) {
                        await humanDragToValue(el, res1, bowWidth2);
                    } else {
                        console.log("bad");
                    }
                }
                
            } else {
                log("Can't solved");
                
                el = document.querySelector("button[data-testid=\"refresh\"]");
                if (el) { 
                    await humanClick(el);
                    await new Promise(r => setTimeout(r, 3000));
                } else {
                    log("Не найти кнопку ресет");
                    return;
                }
            }
        }
    }
}

async function humanClickOnCanvas(x, y) {
    let canvas = document.querySelector(".AdvancedCaptcha-ImageWrapper");
    if (!canvas) return;
    
    let rect = canvas.getBoundingClientRect();
    
    await humanMoveTo(canvas, x, y);
    await humanDelay('micro');
    
    const pointerId = getNextPointerId();
    const screenProps = getScreenProps();
    
    const pointerDown = new PointerEvent('pointerdown', {
        bubbles: true,
        cancelable: true,
        pointerId: pointerId,
        pointerType: 'mouse',
        clientX: mouseHistory.x,
        clientY: mouseHistory.y,
        screenX: screenProps.screenX,
        screenY: screenProps.screenY,
        width: 1 + secureRandom() * 0.5,
        height: 1 + secureRandom() * 0.5,
        pressure: 0.5 + secureRandom() * 0.3,
        tiltX: randomGaussian(0, 3),
        tiltY: randomGaussian(0, 3),
        isPrimary: true
    });
    
    canvas.dispatchEvent(pointerDown);
    
    await new Promise(r => setTimeout(r, randomLogNormal(4.2, 0.2)));
    
    const pointerUp = new PointerEvent('pointerup', {
        bubbles: true,
        cancelable: true,
        pointerId: pointerId,
        pointerType: 'mouse',
        clientX: mouseHistory.x,
        clientY: mouseHistory.y,
        pressure: 0
    });
    
    canvas.dispatchEvent(pointerUp);
}

async function humanDragToValue(thumbElement, targetValue, maxWidth) {
    const rect = thumbElement.getBoundingClientRect();
    const startX = rect.left + rect.width / 2;
    const startY = rect.top + rect.height / 2;
    
    await humanMoveTo(thumbElement, 0, 0, { startX: mouseHistory.x, startY: mouseHistory.y });
    await humanDelay('reaction');
    
    const pointerDown = new PointerEvent('pointerdown', {
        bubbles: true,
        cancelable: true,
        pointerId: getNextPointerId(),
        pointerType: 'mouse',
        clientX: mouseHistory.x,
        clientY: mouseHistory.y,
        pressure: 0.8,
        buttons: 1
    });
    thumbElement.dispatchEvent(pointerDown);
    
    const mousedown = new MouseEvent('mousedown', {
        bubbles: true,
        cancelable: true,
        clientX: mouseHistory.x,
        clientY: mouseHistory.y,
        button: 0,
        buttons: 1
    });
    thumbElement.dispatchEvent(mousedown);
    
    await humanDelay('micro');
    
    
    
    
    const sliderEl = thumbElement.closest('.CaptchaSlider');
    const sliderRect = sliderEl ? sliderEl.getBoundingClientRect() : null;
    const trackWidth = (sliderRect && sliderRect.width) ? sliderRect.width : maxWidth;
    const maxDistance = Math.max(0, trackWidth - rect.width);

    const ariaMaxRaw = thumbElement.getAttribute('aria-valuemax');
    const ariaMax = ariaMaxRaw ? parseInt(ariaMaxRaw, 10) : 100;
    const ariaMinRaw = thumbElement.getAttribute('aria-valuemin');
    const ariaMin = ariaMinRaw ? parseInt(ariaMinRaw, 10) : 0;

    
    let targetAria = Number.isFinite(targetValue) ? Math.trunc(targetValue) : ariaMax;
    if (targetAria > ariaMax + 2) {
        
        if (maxDistance > 0) {
            targetAria = Math.round((targetAria / maxDistance) * (ariaMax - ariaMin) + ariaMin);
        } else if (trackWidth > 0) {
            targetAria = Math.round((targetAria / trackWidth) * (ariaMax - ariaMin) + ariaMin);
        }
    }
    targetAria = Math.max(ariaMin, Math.min(ariaMax, targetAria));

    
    const stepPxBase = 5; 
    let i = 0;
    let lastAria = null;
    let safety = 0;

    for (i = 0; i <= maxDistance && safety < 2000; i += stepPxBase) {
        safety++;
        const currentX = startX + i + randomGaussian(0, 0.6);
        const currentY = startY + randomGaussian(0, 1.2);

        updateMouseHistory(currentX, currentY);
        const screenProps = getScreenProps();

        thumbElement.dispatchEvent(new MouseEvent('mousemove', {
            bubbles: true,
            cancelable: true,
            clientX: currentX,
            clientY: currentY,
            screenX: screenProps.screenX,
            screenY: screenProps.screenY,
            movementX: screenProps.movementX,
            movementY: screenProps.movementY,
            buttons: 1
        }));

        
        await new Promise(r => setTimeout(r, 90 + Math.floor(secureRandom() * 90)));

        const nowRaw = thumbElement.getAttribute('aria-valuenow');
        const nowAria = nowRaw ? parseInt(nowRaw, 10) : null;
        if (nowAria !== null) {
            lastAria = nowAria;
            
            
            if (nowAria === targetAria) break;
            if (nowAria > targetAria) {
                let back = 0;
                while (back < 25) {
                    back++;
                    const bx = (startX + i) - back; 
                    updateMouseHistory(bx, currentY);
                    const sp = getScreenProps();
                    thumbElement.dispatchEvent(new MouseEvent('mousemove', {
                        bubbles: true,
                        cancelable: true,
                        clientX: bx,
                        clientY: currentY,
                        screenX: sp.screenX,
                        screenY: sp.screenY,
                        buttons: 1
                    }));
                    await new Promise(r => setTimeout(r, 60 + Math.floor(secureRandom() * 60)));
                    const bNowRaw = thumbElement.getAttribute('aria-valuenow');
                    const bNow = bNowRaw ? parseInt(bNowRaw, 10) : null;
                    if (bNow === targetAria) { lastAria = bNow; break; }
                    if (bNow !== null) lastAria = bNow;
                }
                break;
            }
        }

        if (secureRandom() < 0.04) {
            await humanDelay('micro');
        }
    }

    
    if (lastAria === null) {
        const fallbackDistance = (targetAria / (ariaMax - ariaMin || 100)) * maxDistance;
        const targetX = startX + Math.max(0, Math.min(maxDistance, fallbackDistance));
        updateMouseHistory(targetX, startY);
        const screenProps = getScreenProps();
        thumbElement.dispatchEvent(new MouseEvent('mousemove', {
            bubbles: true,
            cancelable: true,
            clientX: targetX,
            clientY: startY,
            screenX: screenProps.screenX,
            screenY: screenProps.screenY,
            buttons: 1
        }));
        await new Promise(r => setTimeout(r, 30));
    }
    
    await humanDelay('micro');
    
    const pointerUp = new PointerEvent('pointerup', {
        bubbles: true,
        cancelable: true,
        pointerId: getNextPointerId(),
        pointerType: 'mouse',
        clientX: mouseHistory.x,
        clientY: mouseHistory.y,
        pressure: 0
    });
    thumbElement.dispatchEvent(pointerUp);
    
    const mouseup = new MouseEvent('mouseup', {
        bubbles: true,
        cancelable: true,
        clientX: mouseHistory.x,
        clientY: mouseHistory.y,
        button: 0
    });
    thumbElement.dispatchEvent(mouseup);
    
    await new Promise(r => setTimeout(r, randomGaussian(500, 100)));
}

function simulateEnterPress(str) {
    const inputField = document.querySelector(str);
    if (inputField) {
        const event = new KeyboardEvent('keydown', {
            key: 'Enter',
            code: 'Enter',
            keyCode: 13,
            which: 13,
            bubbles: true,
            cancelable: true
        });
        inputField.dispatchEvent(event);
    } else {
        log("Can't click ENTER");
    }
}



function isVisible(el) {
    if (!el) return false;
    const style = window.getComputedStyle(el);
    return !!(el.offsetWidth || el.offsetHeight || el.getClientRects().length) 
        && style.visibility !== 'hidden' 
        && style.display !== 'none';
}

function log(...args) {
    console.log('[YandexCaptcha]', ...args);
}

function hasSrt(str, substr) {
    return str.indexOf(substr) !== -1;
}