let capUse = false;
let onoffk1 = false, onoffk2 = false;
let capUseCount = 0;

document.addEventListener('DOMContentLoaded', async function() {
    let maxuse = 3;

    let timerId = setInterval(async () => {
        let onoffk1 = !await onoff('tiktok');
        if(onoffk1) { 
            if(onoffk2 == onoffk1) { return false; } 
            log("Plugin OFF");
            onoffk2 = onoffk1;
            return false;
        } else { 
            if(onoffk2 != onoffk1) { capUse = false; }
            onoffk2 = false; 
        }

        if(!capUse) {
            let el; 
            
            
            el = document.querySelector(".captcha_verify_container");
            if(el && isVisible(el)) {
                console.log("OLD CAPTCHA SHOW");
                capUse = true;
                if(maxuse < 0) { console.log("Sorry, we can't solved"); clearInterval(timerId); }
                maxuse--;
                await eStart();
            }
            
            
            el = document.querySelector(".TUXModal.captcha-verify-container");
            if(el && isVisible(el) && capUseCount >= 0 && capUseCount < 5) {
                if(!capUse) {
                    capUse = true;
                    console.log("NEW CAPTCHA SHOW");
                    let reskk = await eStartNew();
                    if(!reskk) { 
                        capUseCount++; 
                    } else { 
                        capUseCount = 0; 
                    }
                    capUse = false;
                }
            } else if(capUseCount >= 5) {
                capUseCount = -1;
                setTimeout(() => { capUseCount = 0; capUse = false; }, 20000);
            }
        }
    }, 2 * 1000);
});


async function getBlobAsBase64(blobUrl) {
    try {
        const response = await fetch(blobUrl);
        if (!response.ok) {
            throw new Error(`Failed to fetch blob: ${response.status}`);
        }
        const blob = await response.blob();
        return new Promise((resolve, reject) => {
            const reader = new FileReader();
            reader.onloadend = () => {
                const base64 = reader.result.replace(/^data:image\/(png|jpeg|jpg|webp);base64,/, "");
                resolve(base64);
            };
            reader.onerror = () => reject(new Error("Failed to read blob"));
            reader.readAsDataURL(blob);
        });
    } catch (error) {
        console.error("Error converting blob to base64:", error);
        return null;
    }
}


async function getImageAsBase64(url) {
    if (!url) return null;
    
    try {
        if (url.startsWith("blob:")) {
            return await getBlobAsBase64(url);
        } else if (url.startsWith("data:")) {
            return url.replace(/^data:image\/(png|jpeg|jpg|webp);base64,/, "");
        } else {
            return await getBase64FromImageUrl(url);
        }
    } catch (error) {
        console.error("Error getting image as base64:", error);
        return null;
    }
}


async function detectCaptchaType(container) {
    if (!container) return "unknown";

    
    const puzzlePiece = container.querySelector('div[draggable="true"] img, div[draggable="true"] > img, .cap-justify-center div[draggable="true"] img');
    if (puzzlePiece && isVisible(puzzlePiece)) {
        console.log("Detected: pazl (puzzle piece is draggable)");
        return "pazl";
    }

    const images = Array.from(container.querySelectorAll("img"));
    const imageCount = images.length;

    
    const hasCircleClip = images.some(img => (img.style?.clipPath || "").includes("circle"));
    const hasAbsoluteImg = images.some(img => img.classList && img.classList.contains("cap-absolute"));
    const hasWhirlOuter = container.querySelector('[data-testid="whirl-outer-img"]') !== null;
    const hasWhirlInner = container.querySelector('[data-testid="whirl-inner-img"]') !== null;
    if ((hasWhirlOuter && hasWhirlInner) || (imageCount >= 2 && (hasCircleClip || hasAbsoluteImg))) {
        console.log("Detected: koleso (rotation captcha)");
        return "koleso";
    }

    
    const hasSlider =
        container.querySelector(".captcha_verify_img_slide") !== null ||
        container.querySelector("#captcha_slide_button") !== null ||
        container.querySelector(".secsdk-captcha-drag-icon") !== null ||
        container.querySelector('.cap-rounded-full > div') !== null;
    if (hasSlider) {
        console.log("Detected: slider (slider captcha)");
        return "slider";
    }

    
    const instructionText = (container.querySelector("span.cap-flex.cap-items-center")?.textContent || "").trim().toLowerCase();
    const looksLikeObjects =
        (imageCount === 1 && !hasCircleClip) &&
        (instructionText.includes("select") || instructionText.includes("tap") || instructionText.includes("object") ||
         instructionText.includes("выберите") || instructionText.includes("нажмите") || instructionText.includes("объект"));
    if (looksLikeObjects) {
        console.log("Detected: objects (same objects click captcha)");
        return "objects";
    }

    
    if (imageCount === 1) {
        console.log("Detected: abc (single image click captcha)");
        return "abc";
    }

    console.log("Detected: unknown", { imageCount });
    return "unknown";
}


let lastRefreshTime = 0;
const REFRESH_COOLDOWN = 3000; 

async function refreshCaptcha(container) {
    const now = Date.now();
    
    
    if (now - lastRefreshTime < REFRESH_COOLDOWN) {
        console.log("Refresh on cooldown, skipping...");
        return false;
    }
    
    lastRefreshTime = now;
    console.log("Refreshing captcha...");
    
    
    const refreshButtons = [
        container.querySelector("#captcha_refresh_button"),
        container.querySelector(".captcha-refresh-button"),
        container.querySelector("[data-testid='refresh-button']"),
        ...Array.from(container.querySelectorAll("button")).filter(btn => 
            btn.innerHTML.includes("refresh") ||
            btn.innerHTML.includes("M56.62 21a25.5 25.5") ||
            btn.title?.toLowerCase().includes("refresh")
        )
    ].filter(btn => btn);
    
    if (refreshButtons.length > 0) {
        console.log("Found refresh button, clicking...");
        refreshButtons[0].click();
        await delay(2000);
        return true;
    }
    
    
    console.log("No refresh button found, trying old methods...");
    await refresh();
    return false;
}


async function getImagesAsBase64Array(container, captchaType) {
    if (!container) return [];
    
    let images = [];
    
    if (captchaType === "koleso") {
        
        const outerImg = container.querySelector("[data-testid=\"whirl-outer-img\"]");
        const innerImg = container.querySelector("[data-testid=\"whirl-inner-img\"]");
        
        if (outerImg && innerImg) {
            console.log("Found whirl elements (old structure)");
            images = [outerImg, innerImg];
        } else {
            
            const allImages = Array.from(container.querySelectorAll("img"));
            
            
            const regularImages = allImages.filter(img => !img.classList.contains("cap-absolute"));
            const absoluteImages = allImages.filter(img => img.classList.contains("cap-absolute"));
            
            
            if (regularImages.length > 0) {
                images.push(regularImages[0]);
                console.log("Found outer circle image (regular positioning)");
            }
            
            
            if (absoluteImages.length > 0) {
                images.push(absoluteImages[0]);
                console.log("Found inner circle image (absolute positioning)");
            }
            
            
            if (images.length === 0 && allImages.length >= 2) {
                images = [allImages[0], allImages[1]];
                console.log("Fallback to first 2 images for koleso");
            }
        }
        
        console.log("Koleso images found:", { 
            count: images.length,
            sources: images.map(img => ({
                src: img.src?.substring(0, 50) + "...",
                hasClipPath: !!img.style.clipPath,
                isAbsolute: img.classList.contains("cap-absolute"),
                transform: img.style.transform
            }))
        });


} else if (captchaType === "pazl" && imageData.length === 2) {
            
            requestData = {
                'click': "tiktok",
                "type": "pazl",
                'url': imageData
            };
            console.log("Sending pazl data with 2 images");

} else if (captchaType === "slider") {
        
        const allImages = Array.from(container.querySelectorAll("img"));
        
        
        if (allImages.length > 0) {
            
            const mainImage = container.querySelector("#captcha-verify-image") || 
                             container.querySelector(".captcha_verify_img_slide") ||
                             allImages[0];
            
            if (mainImage) {
                images = [mainImage];
                console.log("Found main slider image:", {
                    src: mainImage.src?.substring(0, 50) + "...",
                    id: mainImage.id,
                    className: mainImage.className
                });
            }
        }
    } else {
        
        images = Array.from(container.querySelectorAll("img"));
    }
    
    const imageData = [];
    
    for (let i = 0; i < images.length; i++) {
        const img = images[i];
        console.log(`Processing image ${i + 1}/${images.length}:`, {
            src: img.src?.substring(0, 100) + "...",
            type: img.src?.startsWith('blob:') ? 'blob' : img.src?.startsWith('data:') ? 'data' : 'url',
            clipPath: img.style.clipPath,
            transform: img.style.transform,
            classes: img.className
        });
        
        const base64Data = await getImageAsBase64(img.src);
        if (base64Data) {
            imageData.push(base64Data);
            console.log(`Image ${i + 1} converted to base64, length:`, base64Data.length);
        } else {
            console.error(`Failed to convert image ${i + 1} to base64`);
        }
    }
    
    console.log(`Retrieved ${imageData.length} images for type ${captchaType}`);
    return imageData;
}


async function performDragAction(element, distance) {
    console.log("Starting drag action with distance:", distance);
    
    const rect = element.getBoundingClientRect();
    const startX = rect.left + rect.width / 2;
    const startY = rect.top + rect.height / 2;
    
    
    const mouseDownEvent = new MouseEvent("mousedown", {
        clientX: startX,
        clientY: startY,
        bubbles: true,
        cancelable: true,
        buttons: 1
    });
    
    element.dispatchEvent(mouseDownEvent);
    await delay(100);
    
    
    const steps = 20;
    const stepDistance = distance / steps;
    
    for (let i = 1; i <= steps; i++) {
        const currentX = startX + (stepDistance * i);
        
        const mouseMoveEvent = new MouseEvent("mousemove", {
            clientX: currentX,
            clientY: startY,
            bubbles: true,
            cancelable: true,
            buttons: 1
        });
        
        element.dispatchEvent(mouseMoveEvent);
        
        
        const dragEvent = new DragEvent("drag", {
            clientX: currentX,
            clientY: startY,
            bubbles: true,
            cancelable: true
        });
        
        element.dispatchEvent(dragEvent);
        
        await delay(50);
    }
    
    const finalX = startX + distance;
    
    const mouseUpEvent = new MouseEvent("mouseup", {
        clientX: finalX,
        clientY: startY,
        bubbles: true,
        cancelable: true,
        buttons: 0
    });
    
    element.dispatchEvent(mouseUpEvent);
    
    
    const dragEndEvent = new DragEvent("dragend", {
        clientX: finalX,
        clientY: startY,
        bubbles: true,
        cancelable: true
    });
    
    element.dispatchEvent(dragEndEvent);
    
    console.log("Drag action completed");
    await delay(300);
}


function extractCoordinatesFromResponse(result) {
    console.log("Extracting coordinates from:", result);
    
    let x = 0, y = 0, w = 0;
    
    
    if (result.includes("coordinates:")) {
        const xMatch = result.match(/x=(\d+)/);
        const yMatch = result.match(/y=(\d+)/);
        const wMatch = result.match(/w=(\d+)/);
        
        if (xMatch) x = parseInt(xMatch[1]);
        if (yMatch) y = parseInt(yMatch[1]);
        if (wMatch) w = parseInt(wMatch[1]);
        
        console.log("Extracted from coordinates format:", { x, y, w });
        return { x, y, w };
    }
    
    
    if (result.includes("x=") && result.includes("y=")) {
        const xMatch = result.match(/x=(\d+)/);
        const yMatch = result.match(/y=(\d+)/);
        
        if (xMatch) x = parseInt(xMatch[1]);
        if (yMatch) y = parseInt(yMatch[1]);
        
        console.log("Extracted from x=;y= format:", { x, y, w: 0 });
        return { x, y, w: 0 };
    }
    
    
    const cleanResult = result.replace(/[^0-9,]/g, "");
    const coords = cleanResult.split(",");
    
    if (coords.length >= 2) {
        x = parseInt(coords[0]) || 0;
        y = parseInt(coords[1]) || 0;
        if (coords.length >= 3) {
            w = parseInt(coords[2]) || 0;
        }
        
        console.log("Extracted from comma format:", { x, y, w });
        return { x, y, w };
    }
    
    console.log("Could not extract coordinates, using defaults");
    return { x: 0, y: 0, w: 0 };
}


async function handleSlideResponse(result, container, captchaType) {
    console.log("Handling slide response:", result);
    
    
    let res1 = result.replace(/[^0-9,]/g, "");
    res1 = res1.split(",")[0]; 
    res1 = parseInt(res1);
    
    console.log("Extracted coordinates from response:", {
        originalResult: result,
        cleanedNumbers: result.replace(/[^0-9,]/g, ""),
        splitArray: result.replace(/[^0-9,]/g, "").split(","),
        selectedValue: res1,
        selectedIndex: 0
    });
    
    
    const el2 = container.querySelector("#captcha-verify-image") || 
               container.querySelector("img");
    
    if (el2 && el2.naturalHeight > 0) {
        
        res1 = Math.round(res1 / el2.naturalHeight * el2.offsetHeight);
        console.log("Scaling calculation (OLD CODE FORMULA):", {
            originalValue: parseInt(result.replace(/[^0-9,]/g, "").split(",")[0]),
            naturalHeight: el2.naturalHeight,
            offsetHeight: el2.offsetHeight,
            scaleFactor: el2.offsetHeight / el2.naturalHeight,
            result: res1
        });
    }
    
    
    const finalDistance = res1 - 5;
    
    console.log("Final distance for slider:", finalDistance);
    
    
    const dragElement = container.querySelector('.cap-rounded-full > div');
    
    if (dragElement) {
        console.log("Starting dragAndDrop2 with distance:", finalDistance);
        await dragAndDrop2Exact(dragElement, finalDistance);
        
        
        await delay(1000);
        
        
        const confirmButton = container.querySelector('.TUXButton-label') ||
                            container.querySelector('.verify-captcha-submit-button') ||
                            container.querySelector('button[type="submit"]');
        
        if (confirmButton) {
            console.log("Clicking confirm button...");
            confirmButton.click();
        }
        
    } else {
        console.error("Drag element (.cap-rounded-full > div) not found");
    }
}


async function handlePuzzleResponse(result, container) {
    console.log("Handling puzzle (pazl) response:", result);

    
    let res1 = result.replace(/[^0-9,]/g, "");
    res1 = res1.split(",")[0];
    res1 = parseInt(res1);

    if (isNaN(res1) || res1 <= 0) {
        console.warn("Invalid pazl distance:", res1, "from result:", result);
        return;
    }

    
    const mainImg =
        container.querySelector("#captcha-verify-image") ||
        container.querySelector("img.captcha_verify_img_slide") ||
        container.querySelector("img");

    if (mainImg && mainImg.naturalWidth > 0) {
        const scaled = Math.round(res1 / mainImg.naturalWidth * mainImg.offsetWidth);
        console.log("Pazl scaling:", {
            original: res1,
            naturalWidth: mainImg.naturalWidth,
            offsetWidth: mainImg.offsetWidth,
            scaled
        });
        res1 = scaled;
    }

    const finalDistance = res1 - 5;

    
    const dragElement =
        container.querySelector('.cap-rounded-full > div') ||
        container.querySelector('.secsdk-captcha-drag-icon') ||
        container.querySelector('#captcha_slide_button') ||
        container.querySelector('[draggable="true"]');

    if (!dragElement) {
        console.error("Pazl drag element not found");
        return;
    }

    console.log("Starting pazl drag with distance:", finalDistance);
    await dragAndDrop2Exact(dragElement, finalDistance);
    await delay(1000);

    const confirmButton =
        container.querySelector('.TUXButton-label') ||
        container.querySelector('.verify-captcha-submit-button') ||
        container.querySelector('button[type="submit"]');
    if (confirmButton) {
        console.log("Clicking confirm button (pazl)...");
        confirmButton.click();
    }
}


async function handleRotateResponse(result, container) {
    console.log("Handling rotate response:", result);
    
    
    const coords = extractCoordinatesFromResponse(result);
    let angle = coords.y; 
    
    if (isNaN(angle) || angle < 0) {
        console.error("Invalid angle value:", angle, "from result:", result);
        return;
    }
    
    console.log("Extracted angle for rotation:", angle);
    
    
    const rotateElement = container.querySelector('.cap-rounded-full > div') ||
                         container.querySelector('.secsdk-captcha-drag-icon') ||
                         container.querySelector('#captcha_slide_button') ||
                         container.querySelector('[draggable="true"]');
    
    if (rotateElement) {
        console.log("Found rotate element, applying rotation...");
        await performTikTokSliderCorrect(rotateElement, angle);
    } else {
        console.error("Rotate element not found");
        
        const allDraggable = container.querySelectorAll('[draggable], .cap-rounded-full, .secsdk-captcha-drag-icon, button');
        console.log("Available draggable elements:", allDraggable);
    }
}


async function handleClickResponse(result, container) {
    console.log("Handling click response:", result);
    
    const cleanResult = result.replace(/[^0-9,\;]/g, "");
    const coordinates = cleanResult.split(";");
    
    const imageElement = container.querySelector("img");
    if (!imageElement) {
        console.error("Image element not found for clicks");
        return;
    }
    
    for (let coordStr of coordinates) {
        const [xStr, yStr] = coordStr.split(",");
        let x = parseInt(xStr);
        let y = parseInt(yStr);
        
        if (isNaN(x) || isNaN(y)) {
            console.warn("Invalid coordinates:", coordStr);
            continue;
        }
        
        
        if (imageElement.naturalHeight > 0 && imageElement.naturalWidth > 0) {
            y = Math.round(y / imageElement.naturalHeight * imageElement.offsetHeight);
            x = Math.round(x / imageElement.naturalWidth * imageElement.offsetWidth);
        }
        
        console.log("Clicking at:", x, y);
        
        await delay(500);
        await elClick(imageElement, x, y);
        await delay(1200);
    }
    
    await delay(2000);
    
    
    const submitButton = container.querySelector(".TUXButton-label") ||
                        container.querySelector(".verify-captcha-submit-button");
    
    if (submitButton) {
        console.log("Clicking submit button...");
        submitButton.click();
    }
}


async function handleCaptchaResponse(response, captchaType, container) {
    try {
        const result = response['received'];
        console.log("Handling captcha response:", { type: captchaType, result });
        
        if (captchaType === "slider") {
            await handleSlideResponse(result, container, captchaType);
        } else if (captchaType === "koleso") {
            await handleRotateResponse(result, container);
        } else if (captchaType === "pazl") {
            await handlePuzzleResponse(result, container);
        } else if (captchaType === "abc" || captchaType === "objects") {
            await handleClickResponse(result, container);
        } else {
            console.warn("Unknown captcha type for response handling:", captchaType);
        }
        
        await delay(2000);
    } catch (error) {
        console.error("Error handling captcha response:", error);
    }
}


async function eStartNew() {
    if (!await onoff('tiktok')) { 
        log("Plugin OFF in cycle");  
        return false; 
    }
    
    const container = document.querySelector(".TUXModal.captcha-verify-container");
    if (!container || !isVisible(container)) {
        return false;
    }
    
    try {
        
        const captchaType = await detectCaptchaType(container);
        console.log("Detected captcha type:", captchaType);
        
        if (captchaType === "unknown") {
            console.warn("Unknown captcha type, refreshing...");
            await refreshCaptcha(container);
            capUse = false;
            return false;
        }
        
        
        const imageData = await getImagesAsBase64Array(container, captchaType);
        
        if (imageData.length === 0) {
            console.warn("No images found, refreshing...");
            await refreshCaptcha(container);
            capUse = false;
            return false;
        }
        
        console.log("Sending captcha data:", { type: captchaType, images: imageData.length });
        
        
        let requestData;
        
        if (captchaType === "koleso" && imageData.length === 2) {
            
            requestData = {
                'click': "tiktok", 
                "type": "koleso", 
                'url': imageData  
            };
            console.log("Sending koleso data with 2 images");
    
} else if (captchaType === "pazl") {
    
    const mainImg =
        container.querySelector("#captcha-verify-image") ||
        container.querySelector("img.captcha_verify_img_slide") ||
        container.querySelector(".captcha_verify_container img") ||
        container.querySelector(".cap-justify-center img") ||
        container.querySelector("img");

    const pieceImg =
        container.querySelector('div[draggable="true"] img, .cap-justify-center div[draggable="true"] img');

    if (mainImg && pieceImg) {
        images = [mainImg, pieceImg];
        console.log("Found pazl images:", {
            main: mainImg.src?.substring(0, 50) + "...",
            piece: pieceImg.src?.substring(0, 50) + "..."
        });
    } else {
        
        const allImages = Array.from(container.querySelectorAll("img"));
        if (allImages.length >= 2) {
            images = [allImages[0], allImages[1]];
            console.log("Pazl fallback to first 2 images");
        }
    }

} else if (captchaType === "slider") {
            
            requestData = {
                'click': "tiktok", 
                "type": "slider", 
                'url': imageData[0]  
            };
            console.log("Sending slider data with 1 image (main image only)");
        } else if (imageData.length === 1) {
            
            requestData = {
                'click': "tiktok", 
                "type": captchaType, 
                'url': imageData[0]  
            };
            console.log("Sending single image data for type:", captchaType);
        } else {
            console.error("Unexpected image data configuration:", {
                type: captchaType,
                imageCount: imageData.length
            });
            await refreshCaptcha(container);
            capUse = false;
            return false;
        }
        
        
        const response = await sendChrome.X('imgs', requestData);
        console.log("Response received:", response);
        
        
        if (!response || !response.received) {
            console.warn("No response received, refreshing...");
            await refreshCaptcha(container);
            capUse = false;
            return false;
        }
        
        const result = response.received;
        
        
        if (result === 'WAIT' || result === '' || hasSrt(result, 'ERROR')) {
            console.warn("Invalid response:", result, "refreshing...");
            await refreshCaptcha(container);
            capUse = false;
            return false;
        }
        
        
        if (captchaType === "koleso") {
            const cleanResult = result.replace(/[^0-9,]/g, "");
            const coordinates = cleanResult.split(",");
            
            if (coordinates.length < 2) {
                console.warn("Invalid koleso response - insufficient coordinates:", result);
                await refreshCaptcha(container);
                capUse = false;
                return false;
            }
        }
        
        
        await handleCaptchaResponse(response, captchaType, container);
        return true;
        
    } catch (error) {
        console.error("Error in eStartNew:", error);
        await refreshCaptcha(container);
        capUse = false;
        return false;
    }
}


async function triggerDragEvent(element, eventName, options = {}) {
    const rect = element.getBoundingClientRect();
    const { clientX = rect.left, clientY = rect.top } = options;

    
    const dragEvent = new DragEvent(eventName, {
        bubbles: true,
        cancelable: true,
        clientX: clientX,
        clientY: clientY,
        dataTransfer: new DataTransfer() 
    });

    
    dragEvent.dataTransfer.setDragImage = (img, xOffset, yOffset) => {
        console.log('setDragImage called with:', img, xOffset, yOffset);
    };

    element.dispatchEvent(dragEvent);
}


async function dragAndDropKoleso(selector, angle) {
    const element = typeof selector === 'string' ? document.querySelector(selector) : selector;
    if (!element) throw new Error("Элемент не найден");

    const rect = element.getBoundingClientRect();
    const container = element.parentElement.getBoundingClientRect();
    const startX = rect.left + rect.width / 2;
    const startY = rect.top + rect.height / 2;

    
    const CONSTANT = 271;
    const elementWidth = rect.width;
    const containerWidth = container.width;
    const maxMovement = containerWidth - elementWidth;
    const offsetX = Math.round((angle / CONSTANT) * maxMovement);

    console.log("Koleso drag calculation:", {
        angle: angle,
        constant: CONSTANT,
        containerWidth: containerWidth,
        elementWidth: elementWidth,
        maxMovement: maxMovement,
        offsetX: offsetX,
        formula: `${angle}/${CONSTANT}*(${containerWidth}-${elementWidth}) = ${offsetX}`
    });

    
    const maxX = container.right - rect.width / 2;
    const targetX = Math.min(maxX, startX + offsetX);
    const targetY = startY;

    
    await triggerDragEvent(element, 'dragstart', { clientX: startX, clientY: startY });
    
    
    for (let i = 0; i <= offsetX; i += 5) {
        const intermediateX = startX + i;
        await triggerDragEvent(element, 'drag', { clientX: intermediateX, clientY: targetY });
        await new Promise(resolve => setTimeout(resolve, 20));
    }
    
    await triggerDragEvent(element, 'drag', { clientX: targetX, clientY: targetY });
    await new Promise(resolve => setTimeout(resolve, 100));

    await triggerDragEvent(element, 'dragend', { clientX: targetX, clientY: targetY });
    
    console.log("Koleso drag completed. Moved to:", targetX);
}


async function dragAndDropSlider(selector, offsetX = 100) {
    const element = typeof selector === 'string' ? document.querySelector(selector) : selector;
    if (!element) throw new Error("Элемент не найден");

    const rect = element.getBoundingClientRect();
    const container = element.parentElement.getBoundingClientRect();
    const startX = rect.left + rect.width / 2;
    const startY = rect.top + rect.height / 2;

    
    const maxX = container.right - rect.width / 2;
    const targetX = Math.min(maxX, startX + offsetX);
    const targetY = startY;

    
    await triggerDragEvent(element, 'dragstart', { clientX: startX, clientY: startY });
    
    
    for (let i = 0; i <= offsetX; i += 5) {
        const intermediateX = startX + i;
        
        await triggerDragEvent(element, 'drag', { clientX: intermediateX, clientY: targetY });
        await new Promise(resolve => setTimeout(resolve, 20));
        
        
        let ce = document.querySelector(".captcha-verify-container img+div");
        if (ce) {
            let sto = ce.getAttribute('style');
            let find3 = sto.match(/\(([0-9.]+)px\)/);
            
            if (find3 && find3.length > 1) {
                let found4 = parseInt(find3[1]);
                if (found4 > offsetX) { 
                    offsetX = intermediateX; 
                    await triggerDragEvent(element, 'drag', { clientX: intermediateX, clientY: targetY });
                    await new Promise(resolve => setTimeout(resolve, 20));
                    break; 
                }
            }
        }
    }

    await new Promise(resolve => setTimeout(resolve, 100));
    await triggerDragEvent(element, 'dragend', { clientX: targetX, clientY: targetY });
}


async function dragAndDrop2Exact(element, offsetX = 100) {
    if (!element) throw new Error("Элемент не найден");

    console.log("Starting EXACT dragAndDrop2 from old code with offsetX:", offsetX);

    const rect = element.getBoundingClientRect();
    const container = element.parentElement.getBoundingClientRect();
    const startX = rect.left + rect.width / 2;
    const startY = rect.top + rect.height / 2;

    
    const maxX = container.right - rect.width / 2;
    const targetX = Math.min(maxX, startX + offsetX);
    const targetY = startY;

    console.log("EXACT dragAndDrop2 coordinates:", {
        startX, startY, offsetX, targetX, maxX,
        elementRect: rect,
        containerRect: container
    });

    
    await triggerDragEvent(element, 'dragstart', { clientX: startX, clientY: startY });
    
    
    for (let i = 0; i <= offsetX; i += 5) {
        const intermediateX = startX + i;
        
        await triggerDragEvent(element, 'drag', { clientX: intermediateX, clientY: targetY });
        await new Promise(resolve => setTimeout(resolve, 20));
        
        
        let ce = document.querySelector(".captcha-verify-container img+div");
        
        if (ce) {
            let sto = ce.getAttribute('style');
            
            if (sto) {
                let find3 = sto.match(/\(([0-9.]+)px\)/);
                
                if (find3 && find3.length > 1) {
                    let found4 = parseInt(find3[1]);
                    console.log("Position check - found4:", found4, "offsetX:", offsetX, "i:", i);
                    
                    if (found4 > offsetX) { 
                        console.log("EXACT TARGET REACHED! found4 > offsetX:", found4, ">", offsetX);
                        
                        
                        offsetX = intermediateX; 
                        
                        await triggerDragEvent(element, 'drag', { clientX: intermediateX, clientY: targetY });
                        await new Promise(resolve => setTimeout(resolve, 20));
                        
                        break; 
                    }
                }
            }
        } else {
            console.log("Element .captcha-verify-container img+div not found at step", i);
        }
    }

    await new Promise(resolve => setTimeout(resolve, 100));
    await triggerDragEvent(element, 'dragend', { clientX: targetX, clientY: targetY });
    
    console.log("EXACT dragAndDrop2 completed");
}


async function performTikTokSliderCorrect(element, angle) {
    console.log("Performing TikTok slider with EXACT formula and original drag method. Angle:", angle);
    
    
    try {
        await dragAndDropKoleso(element, angle);
        console.log("Koleso drag method completed successfully");
        return true;
    } catch (error) {
        console.error("Koleso drag method failed:", error);
        
        
        try {
            const CONSTANT = 271;
            const rect = element.getBoundingClientRect();
            const container = element.parentElement?.getBoundingClientRect() || rect;
            const maxMovement = container.width - rect.width;
            const offsetX = Math.round((angle / CONSTANT) * maxMovement);
            
            await dragAndDropSlider(element, offsetX);
            console.log("Fallback slider drag completed");
            return true;
        } catch (fallbackError) {
            console.error("Fallback drag also failed:", fallbackError);
            return false;
        }
    }
}


async function eStart() {
    let el, el2, el3;
    let res;
    
    for (let i = 0; i < 5; i++) { 
        if(!await onoff('tiktok')) { 
            log("Plugin OFF in cycle");  
            return false; 
        }
    
        let typeCap = "";
        let capImg = "";
        res = null;
        
        el = document.querySelector("#captcha-verify-image");
        console.log(el);
        
        if(el && isVisible(el)) {
            typeCap = "abc";
            let url = el.src;
            if (url !== undefined) {
                el2 = el;
                console.log('clientHeight', el2.offsetHeight, el2.clientHeight);
                
                
                capImg = await getImageAsBase64(url);
            } else {
                console.log("cant get url");
            }
            
            el = document.querySelector(".captcha_verify_img_slide");
            if(el && isVisible(el)) {
                typeCap = "slider";
            }
            
            console.log("Send", typeCap);
            res = await sendChrome.X('imgs', {'click': "tiktok", "type": typeCap, 'url': capImg});
            console.log(res);
        }
        
        el = document.querySelector("[data-testid=\"whirl-outer-img\"]");
        
        if(typeCap.length == 0 && el) {
            typeCap = "koleso";
            let url1 = el.src;
            el = document.querySelector("[data-testid=\"whirl-inner-img\"]");
            let url2 = el.src;
            
            
            const img1Base64 = await getImageAsBase64(url1);
            const img2Base64 = await getImageAsBase64(url2);
            
            console.log("Send", typeCap, url1, url2);
            res = await sendChrome.X('imgs', {'click': "tiktok", "type": typeCap, 'url': [img1Base64, img2Base64]});
            console.log(res);
        }
        
        if (res && 'received' in res && res['received'] && res['received'] !== '' && 
            res['received'] !== 'WAIT' && !hasSrt(res['received'], 'ERROR')) {
            
            let res1;
            if(typeCap == "koleso" || typeCap == "slider") {
                res1 = res['received'].replace(/[^0-9,]/g, "");
                res1 = res1.split(",")[typeCap == "koleso" ? 1 : 0];
                res1 = parseInt(res1);
                if(typeCap == "slider") {  
                    res1 = Math.round(res1 / el2.naturalHeight * el2.offsetHeight);
                }
                
                await elMove(".secsdk-captcha-drag-icon", parseInt(res1), 0);
                
            } else if(typeCap == "abc") {
                console.log('res', res);
                console.log('res_rec', res['received']);
                res1 = res['received'];
                res1 = res1.replace(/[^0-9,\;]/g, "");
                let res2 = res1.split(";");
                
                for(let k in res2) {
                    let wq = res2[k].split(",");
                    let xp = parseInt(wq[0]), yp = parseInt(wq[1]);
                    
                    yp = Math.round(yp / el2.naturalHeight * el2.offsetHeight);
                    xp = Math.round(xp / el2.naturalWidth * el2.offsetWidth);
                
                    await delay(500);
                    await elClick("#captcha-verify-image", xp, yp);
                    await delay(1200);
                }
                await delay(2000);
                document.querySelector(".verify-captcha-submit-button").click();
            }
        } else {
            await refresh();
            capUse = false;
            return false;
        }
        await delay(3000);
    }
    
    console.log("document Error");
}

async function refresh() {
    await elClick(".secsdk_captcha_refresh");
    return await delay(2000);
}

async function clickButtonRef(send = 0) {
    let items = document.querySelectorAll(".captcha-verify-container button, .TUXModal button");
    if(items.length > 0) {
        for (let i = 0, len = items.length; i < len; i++) {
            let htmlr = items[i].innerHTML;
            if(send == 1) {
                if(!contian(htmlr, "iconContainer")) {
                    await elClick(items[i]);
                    return true;
                }
            } else {
                if(contian(htmlr, "M56.62 21a25.5 25.5") || contian(htmlr, "refresh")) {
                    await elClick(items[i]);
                    return true;
                }
            }
        }
    }
    
    
    let refreshBtn = document.querySelector("#captcha_refresh_button");
    if (refreshBtn && send == 0) {
        await elClick(refreshBtn);
        return true;
    }
    
    let submitBtn = document.querySelector(".TUXButton-label");
    if (submitBtn && send == 1) {
        await elClick(submitBtn);
        return true;
    }
}

function contian(str, word) {
    return str.indexOf(word) !== -1;
}